/*
 * Decompiled with CFR 0.152.
 */
package com.eastnine.livelifecycle.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.DimenRes;
import com.eastnine.livelifecycle.util.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J2\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\bJ\"\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\bJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c\u00a8\u0006\u001e"}, d2={"Lcom/eastnine/livelifecycle/util/Util;", "", "()V", "dimenToDp", "", "context", "Landroid/content/Context;", "dimen", "", "dpToPixel", "size", "getDeviceHeight", "getDeviceWidth", "getNavigationHeight", "getStatusBarHeight", "getTextHeight", "typeface", "Landroid/graphics/Typeface;", "text", "", "textSize", "layoutSize", "getTextWidth", "isOnline", "", "pixelToDp", "pixel", "resizeBitmap", "Landroid/graphics/Bitmap;", "bitmap", "LiveLifecycle-Util_v1.0.0_release"})
public final class Util {
    public static final Util INSTANCE;

    public final int getDeviceWidth(@NotNull Context context) {
        Resources resources;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources2 = resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        DisplayMetrics dm = resources2.getDisplayMetrics();
        return dm.widthPixels;
    }

    public final int getDeviceHeight(@NotNull Context context) {
        Resources resources;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources2 = resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        DisplayMetrics dm = resources2.getDisplayMetrics();
        return dm.heightPixels;
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            n = resources.getDimensionPixelSize(resourceId);
        } else {
            float f = Build.VERSION.SDK_INT >= 23 ? 24 : 25;
            Resources resources2 = resources;
            Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
            double d = f * resources2.getDisplayMetrics().density;
            boolean bl = false;
            n = (int)Math.ceil(d);
        }
        return n;
    }

    public final int getNavigationHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        return resourceId > 0 ? resources.getDimensionPixelSize(resourceId) : 0;
    }

    public final int dpToPixel(@NotNull Context context, int size) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        float f = size;
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public final float dpToPixel(@NotNull Context context, float size) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return TypedValue.applyDimension((int)1, (float)size, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public final float pixelToDp(@NotNull Context context, float pixel) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return pixel / ((float)metrics.densityDpi / 160.0f);
    }

    public final int pixelToDp(@NotNull Context context, int pixel) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return (int)((float)pixel / ((float)metrics.densityDpi / 160.0f));
    }

    public final float dimenToDp(@NotNull Context context, @DimenRes int dimen) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        float f = context.getResources().getDimension(dimen);
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return f / resources.getDisplayMetrics().density;
    }

    public final boolean isOnline(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    public final int getTextHeight(@NotNull Context context, @Nullable Typeface typeface, @NotNull String text, float textSize, int layoutSize) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Typeface mTypeface = typeface;
        if (mTypeface == null) {
            mTypeface = Typeface.DEFAULT;
        }
        Paint mPaint = new Paint(1);
        mPaint.setTypeface(mTypeface);
        mPaint.setColor(Color.parseColor((String)"#000000"));
        mPaint.setTextSize(textSize);
        Rect rect = new Rect();
        mPaint.getTextBounds(text, 0, text.length(), rect);
        int lines = (int)(((float)rect.height() + (float)this.dpToPixel(context, 4)) / (float)layoutSize) + 1;
        float textHeight = textSize + context.getResources().getDimension(R.dimen.text_spacing);
        return (int)textHeight * lines;
    }

    public static /* synthetic */ int getTextHeight$default(Util util, Context context, Typeface typeface, String string, float f, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typeface = null;
        }
        return util.getTextHeight(context, typeface, string, f, n);
    }

    public final int getTextWidth(@Nullable Typeface typeface, @NotNull String text, float textSize) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Typeface mTypeface = typeface;
        if (mTypeface == null) {
            mTypeface = Typeface.DEFAULT;
        }
        Paint mPaint = new Paint(1);
        mPaint.setTypeface(mTypeface);
        mPaint.setColor(Color.parseColor((String)"#000000"));
        mPaint.setTextSize(textSize);
        Rect rect = new Rect();
        mPaint.getTextBounds(text, 0, text.length(), rect);
        return rect.width();
    }

    public static /* synthetic */ int getTextWidth$default(Util util, Typeface typeface, String string, float f, int n, Object object) {
        if ((n & 1) != 0) {
            typeface = null;
        }
        return util.getTextWidth(typeface, string, f);
    }

    @NotNull
    public final Bitmap resizeBitmap(@NotNull Context context, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int max = 3379;
        if (bitmap.getWidth() > max || bitmap.getHeight() > max) {
            int resizedWidth = 0;
            int resizedHeight = 0;
            if (bitmap.getWidth() > bitmap.getHeight()) {
                float aspectRatio = (float)bitmap.getWidth() / (float)bitmap.getHeight();
                resizedHeight = this.getDeviceHeight(context);
                resizedWidth = (int)((double)resizedHeight * (double)aspectRatio);
            } else {
                float aspectRatio = (float)bitmap.getHeight() / (float)bitmap.getWidth();
                resizedWidth = this.getDeviceWidth(context);
                resizedHeight = (int)((double)resizedWidth * (double)aspectRatio);
            }
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)resizedWidth, (int)resizedHeight, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createScaledBitma\u2026th, resizedHeight, false)");
            return bitmap2;
        }
        return bitmap;
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
    }
}

