/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.ijk.widget.media;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import com.easefun.polyvsdk.ijk.application.Settings;
import com.easefun.polyvsdk.ijk.widget.media.IMediaController;
import com.easefun.polyvsdk.ijk.widget.media.IRenderView;
import com.easefun.polyvsdk.ijk.widget.media.MediaPlayerCompat;
import com.easefun.polyvsdk.ijk.widget.media.SurfaceRenderView;
import com.easefun.polyvsdk.ijk.widget.media.TextureRenderView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import tv.danmaku.ijk.media.exo.IjkExoMediaPlayer;
import tv.danmaku.ijk.media.player.AndroidMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;
import tv.danmaku.ijk.media.player.TextureMediaPlayer;
import tv.danmaku.ijk.media.player.misc.ITrackInfo;

public class IjkVideoView
extends FrameLayout
implements MediaController.MediaPlayerControl {
    private String TAG = "IjkVideoView";
    private Uri mUri;
    private Map<String, String> mHeaders;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private IRenderView.ISurfaceHolder mSurfaceHolder = null;
    private IMediaPlayer mMediaPlayer = null;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mVideoRotationDegree;
    private IMediaController mMediaController;
    private IMediaPlayer.OnCompletionListener mOnCompletionListener;
    private IMediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private IMediaPlayer.OnErrorListener mOnErrorListener;
    private IMediaPlayer.OnInfoListener mOnInfoListener;
    private int mSeekWhenPrepared;
    private boolean mCanPause = true;
    private boolean mCanSeekBack = true;
    private boolean mCanSeekForward = true;
    private Context mAppContext;
    private Settings mSettings;
    private IRenderView mRenderView;
    private int mVideoSarNum;
    private int mVideoSarDen;
    IMediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sarNum, int sarDen) {
            IjkVideoView.this.mVideoWidth = mp.getVideoWidth();
            IjkVideoView.this.mVideoHeight = mp.getVideoHeight();
            IjkVideoView.this.mVideoSarNum = mp.getVideoSarNum();
            IjkVideoView.this.mVideoSarDen = mp.getVideoSarDen();
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                }
                IjkVideoView.this.requestLayout();
            }
        }
    };
    IMediaPlayer.OnPreparedListener mPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer mp) {
            IjkVideoView.this.mCurrentState = 2;
            if (IjkVideoView.this.mOnPreparedListener != null) {
                IjkVideoView.this.mOnPreparedListener.onPrepared(IjkVideoView.this.mMediaPlayer);
            }
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.setEnabled(true);
            }
            IjkVideoView.this.mVideoWidth = mp.getVideoWidth();
            IjkVideoView.this.mVideoHeight = mp.getVideoHeight();
            int seekToPosition = IjkVideoView.this.mSeekWhenPrepared;
            if (seekToPosition != 0) {
                IjkVideoView.this.seekTo(seekToPosition);
            }
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                    if (!IjkVideoView.this.mRenderView.shouldWaitForResize() || IjkVideoView.this.mSurfaceWidth == IjkVideoView.this.mVideoWidth && IjkVideoView.this.mSurfaceHeight == IjkVideoView.this.mVideoHeight) {
                        if (IjkVideoView.this.mTargetState == 3) {
                            IjkVideoView.this.start();
                        } else if (!IjkVideoView.this.isPlaying() && seekToPosition == 0 && IjkVideoView.this.getCurrentPosition() > 0) {
                            // empty if block
                        }
                    }
                }
            } else if (IjkVideoView.this.mTargetState == 3) {
                IjkVideoView.this.start();
            }
        }
    };
    private IMediaPlayer.OnCompletionListener mCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer mp) {
            IjkVideoView.this.mCurrentState = 5;
            IjkVideoView.this.mTargetState = 5;
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnCompletionListener != null) {
                IjkVideoView.this.mOnCompletionListener.onCompletion(IjkVideoView.this.mMediaPlayer);
            }
        }
    };
    private IMediaPlayer.OnInfoListener mInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer mp, int arg1, int arg2) {
            if (IjkVideoView.this.mOnInfoListener != null) {
                IjkVideoView.this.mOnInfoListener.onInfo(mp, arg1, arg2);
            }
            switch (arg1) {
                case 700: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_VIDEO_TRACK_LAGGING:");
                    break;
                }
                case 3: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_VIDEO_RENDERING_START:");
                    break;
                }
                case 701: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BUFFERING_START:");
                    break;
                }
                case 702: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BUFFERING_END:");
                    break;
                }
                case 703: {
                    Log.d((String)IjkVideoView.this.TAG, (String)("MEDIA_INFO_NETWORK_BANDWIDTH: " + arg2));
                    break;
                }
                case 800: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_BAD_INTERLEAVING:");
                    break;
                }
                case 801: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_NOT_SEEKABLE:");
                    break;
                }
                case 802: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_METADATA_UPDATE:");
                    break;
                }
                case 901: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_UNSUPPORTED_SUBTITLE:");
                    break;
                }
                case 902: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_SUBTITLE_TIMED_OUT:");
                    break;
                }
                case 10001: {
                    IjkVideoView.this.mVideoRotationDegree = arg2;
                    Log.d((String)IjkVideoView.this.TAG, (String)("MEDIA_INFO_VIDEO_ROTATION_CHANGED: " + arg2));
                    if (IjkVideoView.this.mRenderView == null) break;
                    IjkVideoView.this.mRenderView.setVideoRotation(arg2);
                    break;
                }
                case 10002: {
                    Log.d((String)IjkVideoView.this.TAG, (String)"MEDIA_INFO_AUDIO_RENDERING_START:");
                }
            }
            return true;
        }
    };
    private IMediaPlayer.OnErrorListener mErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer mp, int framework_err, int impl_err) {
            Log.d((String)IjkVideoView.this.TAG, (String)("Error: " + framework_err + "," + impl_err));
            IjkVideoView.this.mCurrentState = -1;
            IjkVideoView.this.mTargetState = -1;
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnErrorListener != null && IjkVideoView.this.mOnErrorListener.onError(IjkVideoView.this.mMediaPlayer, framework_err, impl_err)) {
                return true;
            }
            if (IjkVideoView.this.getWindowToken() != null) {
                Resources r = IjkVideoView.this.mAppContext.getResources();
                String message = framework_err == 200 ? "Invalid progressive playback" : "Unknown";
                new AlertDialog.Builder(IjkVideoView.this.getContext()).setMessage((CharSequence)message).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (IjkVideoView.this.mOnCompletionListener != null) {
                            IjkVideoView.this.mOnCompletionListener.onCompletion(IjkVideoView.this.mMediaPlayer);
                        }
                    }
                }).setCancelable(false).show();
            }
            return true;
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(IMediaPlayer mp, int percent) {
            IjkVideoView.this.mCurrentBufferPercentage = percent;
        }
    };
    IRenderView.IRenderCallback mSHCallback = new IRenderView.IRenderCallback(){

        @Override
        public void onSurfaceChanged(@NonNull IRenderView.ISurfaceHolder holder, int format, int w, int h) {
            boolean hasValidSize;
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceChanged: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceWidth = w;
            IjkVideoView.this.mSurfaceHeight = h;
            boolean isValidState = IjkVideoView.this.mTargetState == 3;
            boolean bl = hasValidSize = !IjkVideoView.this.mRenderView.shouldWaitForResize() || IjkVideoView.this.mVideoWidth == w && IjkVideoView.this.mVideoHeight == h;
            if (IjkVideoView.this.mMediaPlayer != null && isValidState && hasValidSize) {
                if (IjkVideoView.this.mSeekWhenPrepared != 0) {
                    IjkVideoView.this.seekTo(IjkVideoView.this.mSeekWhenPrepared);
                }
                if (IjkVideoView.this.mIsClearCanvasInStart) {
                    IjkVideoView.this.mIsClearCanvasInStart = false;
                    IjkVideoView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            Canvas canvas;
                            if (IjkVideoView.this.getSurfaceHolder() != null && (canvas = IjkVideoView.this.getSurfaceHolder().lockCanvas(new Rect(0, 0, IjkVideoView.this.mSurfaceWidth, IjkVideoView.this.mSurfaceHeight))) != null) {
                                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                                IjkVideoView.this.getSurfaceHolder().unlockCanvasAndPost(canvas);
                                IjkVideoView.this.bindSurfaceHolder(IjkVideoView.this.mMediaPlayer, IjkVideoView.this.mSurfaceHolder);
                            }
                        }
                    });
                }
                IjkVideoView.this.start();
            }
        }

        @Override
        public void onSurfaceCreated(@NonNull IRenderView.ISurfaceHolder holder, int width, int height) {
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceCreated: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = holder;
            if (IjkVideoView.this.mMediaPlayer != null) {
                IjkVideoView.this.bindSurfaceHolder(IjkVideoView.this.mMediaPlayer, holder);
            } else {
                IjkVideoView.this.openVideo();
            }
        }

        @Override
        public void onSurfaceDestroyed(@NonNull IRenderView.ISurfaceHolder holder) {
            if (holder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e((String)IjkVideoView.this.TAG, (String)"onSurfaceDestroyed: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = null;
            IjkVideoView.this.releaseWithoutStop();
        }
    };
    private static final int[] s_allAspectRatio = new int[]{0, 1, 2, 4, 5};
    private int mCurrentAspectRatioIndex = 0;
    private int mCurrentAspectRatio = s_allAspectRatio[0];
    public static final int RENDER_NONE = 0;
    public static final int RENDER_SURFACE_VIEW = 1;
    public static final int RENDER_TEXTURE_VIEW = 2;
    private List<Integer> mAllRenders = new ArrayList<Integer>();
    private int mCurrentRenderIndex = 0;
    private int mCurrentRender = 0;
    private Object[][] mOptionParameters;
    private boolean mIsClearCanvasInStart;
    public boolean mIsLooping;
    public int ijkLogLevel = 3;

    public IjkVideoView(Context context) {
        super(context);
        this.initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVideoView(context);
    }

    @TargetApi(value=21)
    public IjkVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initVideoView(context);
    }

    private void initVideoView(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mSettings = new Settings(this.mAppContext);
        this.initRenders();
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    public void setRenderView(IRenderView renderView) {
        View renderUIView;
        if (this.mRenderView != null) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setDisplay(null);
            }
            renderUIView = this.mRenderView.getView();
            this.mRenderView.removeRenderCallback(this.mSHCallback);
            this.mRenderView = null;
            this.removeView(renderUIView);
        }
        if (renderView == null) {
            return;
        }
        this.mRenderView = renderView;
        renderView.setAspectRatio(this.mCurrentAspectRatio);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            renderView.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
        if (this.mVideoSarNum > 0 && this.mVideoSarDen > 0) {
            renderView.setVideoSampleAspectRatio(this.mVideoSarNum, this.mVideoSarDen);
        }
        renderUIView = this.mRenderView.getView();
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2, 17);
        renderUIView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView(renderUIView);
        this.mRenderView.addRenderCallback(this.mSHCallback);
        this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
    }

    public void setRender(int render) {
        switch (render) {
            case 0: {
                this.setRenderView(null);
                break;
            }
            case 2: {
                TextureRenderView renderView = new TextureRenderView(this.getContext());
                if (this.mMediaPlayer != null) {
                    renderView.getSurfaceHolder().bindToMediaPlayer(this.mMediaPlayer);
                    renderView.setVideoSize(this.mMediaPlayer.getVideoWidth(), this.mMediaPlayer.getVideoHeight());
                    renderView.setVideoSampleAspectRatio(this.mMediaPlayer.getVideoSarNum(), this.mMediaPlayer.getVideoSarDen());
                    renderView.setAspectRatio(this.mCurrentAspectRatio);
                }
                this.setRenderView(renderView);
                break;
            }
            case 1: {
                SurfaceRenderView renderView = new SurfaceRenderView(this.getContext());
                this.setRenderView(renderView);
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)String.format(Locale.getDefault(), "invalid render %d\n", render));
            }
        }
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    private void setVideoURI(Uri uri, Map<String, String> headers) {
        this.mUri = uri;
        this.mHeaders = headers;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
            AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
            am.abandonAudioFocus(null);
        }
    }

    @TargetApi(value=23)
    private void openVideo() {
        if (this.mUri == null || this.mSurfaceHolder == null) {
            return;
        }
        this.release(false);
        AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
        am.requestAudioFocus(null, 3, 1);
        try {
            this.mMediaPlayer = this.createPlayer(this.mSettings.getPlayer());
            this.setOption(this.mMediaPlayer);
            this.mMediaPlayer.setLooping(this.mIsLooping);
            Context context = this.getContext();
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            if (Build.VERSION.SDK_INT > 14) {
                this.mMediaPlayer.setDataSource(this.mAppContext, this.mUri, this.mHeaders);
            } else {
                this.mMediaPlayer.setDataSource(this.mUri.toString());
            }
            this.bindSurfaceHolder(this.mMediaPlayer, this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.attachMediaController();
        }
        catch (IOException ex) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
        }
        catch (IllegalArgumentException ex) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
        }
    }

    public void setMediaController(IMediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            IjkVideoView anchorView = this.getParent() instanceof View ? (View)this.getParent() : this;
            this.mMediaController.setAnchorView((View)anchorView);
            this.mMediaController.setEnabled(this.isInPlaybackState());
        }
    }

    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(IMediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnInfoListener(IMediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    private void bindSurfaceHolder(IMediaPlayer mp, IRenderView.ISurfaceHolder holder) {
        if (mp == null) {
            return;
        }
        if (holder == null) {
            mp.setDisplay(null);
            return;
        }
        holder.bindToMediaPlayer(mp);
    }

    public void releaseWithoutStop() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setDisplay(null);
        }
    }

    public synchronized void release(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            if (cleartargetstate) {
                this.mTargetState = 0;
            }
            AudioManager am = (AudioManager)this.mAppContext.getSystemService("audio");
            am.abandonAudioFocus(null);
        }
    }

    public void start() {
        if (this.isInPlaybackState()) {
            try {
                this.mMediaPlayer.start();
                this.mCurrentState = 3;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.mTargetState = 3;
    }

    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
        }
        this.mTargetState = 4;
    }

    public void suspend() {
        this.release(false);
    }

    public void resume() {
        this.openVideo();
    }

    public int getDuration() {
        if (this.isInPlaybackState()) {
            return (int)this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return (int)this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo((long)msec);
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    public boolean canPause() {
        return this.mCanPause;
    }

    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    public int getAudioSessionId() {
        return 0;
    }

    public int toggleAspectRatio() {
        ++this.mCurrentAspectRatioIndex;
        this.mCurrentAspectRatioIndex %= s_allAspectRatio.length;
        this.mCurrentAspectRatio = s_allAspectRatio[this.mCurrentAspectRatioIndex];
        if (this.mRenderView != null) {
            this.mRenderView.setAspectRatio(this.mCurrentAspectRatio);
        }
        return this.mCurrentAspectRatio;
    }

    private void initRenders() {
        this.mAllRenders.clear();
        if (this.mSettings.getEnableSurfaceView()) {
            this.mAllRenders.add(1);
        }
        if (this.mSettings.getEnableTextureView() && Build.VERSION.SDK_INT >= 14) {
            this.mAllRenders.add(2);
        }
        if (this.mSettings.getEnableNoView()) {
            this.mAllRenders.add(0);
        }
        if (this.mAllRenders.isEmpty()) {
            this.mAllRenders.add(1);
        }
        this.mCurrentRender = this.mAllRenders.get(this.mCurrentRenderIndex);
        this.setRender(this.mCurrentRender);
    }

    public int toggleRender() {
        ++this.mCurrentRenderIndex;
        this.mCurrentRenderIndex %= this.mAllRenders.size();
        this.mCurrentRender = this.mAllRenders.get(this.mCurrentRenderIndex);
        this.setRender(this.mCurrentRender);
        return this.mCurrentRender;
    }

    @NonNull
    public static String getRenderText(Context context, int render) {
        String text;
        switch (render) {
            case 0: {
                text = "Render: None";
                break;
            }
            case 1: {
                text = "Render: SurfaceView";
                break;
            }
            case 2: {
                text = "Render: TextureView";
                break;
            }
            default: {
                text = "N/A";
            }
        }
        return text;
    }

    public int togglePlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
        }
        if (this.mRenderView != null) {
            this.mRenderView.getView().invalidate();
        }
        this.openVideo();
        return this.mSettings.getPlayer();
    }

    @NonNull
    public static String getPlayerText(Context context, int player) {
        String text;
        switch (player) {
            case 1: {
                text = "Player: AndroidMediaPlayer";
                break;
            }
            case 2: {
                text = "Player: IjkMediaPlayer";
                break;
            }
            case 3: {
                text = "Player: IjkExoMediaPlayer";
                break;
            }
            default: {
                text = "N/A";
            }
        }
        return text;
    }

    public IMediaPlayer createPlayer(int playerType) {
        AndroidMediaPlayer mediaPlayer = null;
        switch (playerType) {
            case 3: {
                IjkExoMediaPlayer IjkExoMediaPlayer2 = new IjkExoMediaPlayer(this.mAppContext);
                mediaPlayer = IjkExoMediaPlayer2;
                break;
            }
            case 1: {
                AndroidMediaPlayer androidMediaPlayer;
                mediaPlayer = androidMediaPlayer = new AndroidMediaPlayer();
                break;
            }
            default: {
                IjkMediaPlayer ijkMediaPlayer = null;
                if (this.mUri != null) {
                    ijkMediaPlayer = new IjkMediaPlayer();
                    IjkMediaPlayer.native_setLogLevel((int)this.ijkLogLevel);
                    if (this.mSettings.getUsingMediaCodec()) {
                        ijkMediaPlayer.setOption(4, "mediacodec", 1L);
                        if (this.mSettings.getUsingMediaCodecAutoRotate()) {
                            ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 1L);
                        } else {
                            ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 0L);
                        }
                    } else {
                        ijkMediaPlayer.setOption(4, "mediacodec", 0L);
                    }
                    if (this.mSettings.getUsingOpenSLES()) {
                        ijkMediaPlayer.setOption(4, "opensles", 1L);
                    } else {
                        ijkMediaPlayer.setOption(4, "opensles", 0L);
                    }
                    String pixelFormat = this.mSettings.getPixelFormat();
                    if (TextUtils.isEmpty((CharSequence)pixelFormat)) {
                        ijkMediaPlayer.setOption(4, "overlay-format", 842225234L);
                    } else {
                        ijkMediaPlayer.setOption(4, "overlay-format", pixelFormat);
                    }
                    ijkMediaPlayer.setOption(4, "framedrop", 1L);
                    ijkMediaPlayer.setOption(4, "start-on-prepared", 0L);
                    ijkMediaPlayer.setOption(1, "http-detect-range-support", 0L);
                    ijkMediaPlayer.setOption(2, "skip_loop_filter", 48L);
                    ijkMediaPlayer.setOption(4, "soundtouch", 1L);
                }
                mediaPlayer = ijkMediaPlayer;
            }
        }
        if (this.mSettings.getEnableDetachedSurfaceTextureView()) {
            mediaPlayer = new TextureMediaPlayer((IMediaPlayer)mediaPlayer);
        }
        return mediaPlayer;
    }

    public ITrackInfo[] getTrackInfo() {
        if (this.mMediaPlayer == null) {
            return null;
        }
        return this.mMediaPlayer.getTrackInfo();
    }

    public void selectTrack(int stream) {
        MediaPlayerCompat.selectTrack(this.mMediaPlayer, stream);
    }

    public void deselectTrack(int stream) {
        MediaPlayerCompat.deselectTrack(this.mMediaPlayer, stream);
    }

    public int getSelectedTrack(int trackType) {
        return MediaPlayerCompat.getSelectedTrack(this.mMediaPlayer, trackType);
    }

    public boolean isInPlaybackStateForwarding() {
        return this.isInPlaybackState();
    }

    public IRenderView getRenderView() {
        return this.mRenderView;
    }

    public int getCurrentAspectRatio() {
        return this.mCurrentAspectRatio;
    }

    public void setCurrentAspectRatio(int aspectRatio) {
        this.mCurrentAspectRatio = aspectRatio;
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public IMediaPlayer getMediaPlayer() {
        return this.mMediaPlayer;
    }

    public SurfaceHolder getSurfaceHolder() {
        if (this.mSurfaceHolder == null) {
            return null;
        }
        return this.mSurfaceHolder.getSurfaceHolder();
    }

    public void setSpeed(float speed) {
        if (this.mMediaPlayer != null && this.mMediaPlayer instanceof IjkMediaPlayer) {
            IjkMediaPlayer ijkMediaPlayer = (IjkMediaPlayer)this.mMediaPlayer;
            ijkMediaPlayer.setSpeed(speed);
        }
    }

    public float getSpeed() {
        if (this.mMediaPlayer != null && this.mMediaPlayer instanceof IjkMediaPlayer) {
            IjkMediaPlayer ijkMediaPlayer = (IjkMediaPlayer)this.mMediaPlayer;
            return ijkMediaPlayer.getSpeed(0.0f);
        }
        return 0.0f;
    }

    public int getStateIdleCode() {
        return 0;
    }

    public int getStatePreparingCode() {
        return 1;
    }

    public int getStatePreparedCode() {
        return 2;
    }

    public int getStatePauseCode() {
        return 4;
    }

    public int getStatePlaybackCompletedCode() {
        return 5;
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public void clearUri() {
        this.mUri = null;
    }

    public void setOptionParameters(Object[][] mOptionParameters) {
        this.mOptionParameters = mOptionParameters;
    }

    private void setOption(IMediaPlayer mediaPlayer) {
        if (this.mOptionParameters != null && this.mOptionParameters.length > 0 && mediaPlayer instanceof IjkMediaPlayer) {
            for (int i = 0; i < this.mOptionParameters.length; ++i) {
                ((IjkMediaPlayer)mediaPlayer).setOption(((Integer)this.mOptionParameters[i][0]).intValue(), (String)this.mOptionParameters[i][1], (String)this.mOptionParameters[i][2]);
            }
        }
    }

    public void clearOptionParameters() {
        this.mOptionParameters = null;
    }

    public void clearCanvasInStart(boolean mIsClearCanvasInStart) {
        this.mIsClearCanvasInStart = mIsClearCanvasInStart;
    }

    public void setLooping(boolean isLooping) {
        this.mIsLooping = isLooping;
    }

    public void setIjkLogLevel(int ijkLogLevel) {
        this.ijkLogLevel = ijkLogLevel;
    }
}

