/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.auxilliary;

import android.content.Context;
import com.easefun.polyvsdk.sub.auxilliary.NetWorkCheck;
import com.easefun.polyvsdk.sub.auxilliary.PolyvGoApi;
import com.easefun.polyvsdk.sub.auxilliary.PolyvVlmsApi;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitHelper {
    private static OkHttpClient mOkHttpClient;

    public static void init(Context context) {
        RetrofitHelper.initOkHttpClient(context);
    }

    public static PolyvGoApi getPolyvGoApi() {
        return RetrofitHelper.createApi(PolyvGoApi.class, "http://go.polyv.net/");
    }

    public static PolyvVlmsApi getPolyvVlmsApi() {
        return RetrofitHelper.createApi(PolyvVlmsApi.class, "http://demo.vlms.cn/");
    }

    private static <T> T createApi(Class<T> clazz, String baseUrl) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(mOkHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        return (T)retrofit.create(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initOkHttpClient(Context context) {
        if (mOkHttpClient != null) return;
        Class<RetrofitHelper> clazz = RetrofitHelper.class;
        synchronized (RetrofitHelper.class) {
            if (mOkHttpClient != null) return;
            mOkHttpClient = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).addInterceptor((Interceptor)new UserAgentInterceptor()).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class CacheInterceptor
    implements Interceptor {
        private Context context;

        public CacheInterceptor(Context context) {
            this.context = context.getApplicationContext();
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            int maxAge = 3600;
            int maxStale = 86400;
            Request request = chain.request();
            request = NetWorkCheck.isNetworkAvailable(this.context) ? request.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build() : request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
            Response response = chain.proceed(request);
            response = NetWorkCheck.isNetworkAvailable(this.context) ? response.newBuilder().removeHeader("Pragma").header("Cache-Control", "public, max-age=" + maxAge).build() : response.newBuilder().removeHeader("Pragma").header("Cache-Control", "public, only-if-cached, max-stale=" + maxStale).build();
            return response;
        }
    }

    private static class UserAgentInterceptor
    implements Interceptor {
        private UserAgentInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request requestWithUserAgent = originalRequest.newBuilder().removeHeader("User-Agent").addHeader("User-Agent", "my agent").build();
            return chain.proceed(requestWithUserAgent);
        }
    }

    public static class RetryIntercepter
    implements Interceptor {
        public int maxRetry;
        private int retryNum = 0;

        public RetryIntercepter(int maxRetry) {
            this.maxRetry = maxRetry;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Response response = chain.proceed(request);
            while (!response.isSuccessful() && this.retryNum < this.maxRetry) {
                ++this.retryNum;
                response = chain.proceed(request);
            }
            return response;
        }
    }
}

