/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.auxilliary;

import com.easefun.polyvsdk.sub.auxilliary.IListener;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class DifferentCallback<T>
implements Callback<ResponseBody> {
    public IListener<T> listener;

    public DifferentCallback(IListener<T> listener) {
        this.listener = listener;
    }

    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        int code = response.code();
        if (code != 200 && code != 206) {
            this.onFailure(call, new Exception("response code is " + code));
            return;
        }
        if (this.listener != null) {
            try {
                this.listener.success(this.generateT(((ResponseBody)response.body()).string()));
            }
            catch (Exception e) {
                this.onFailure(call, e);
            }
        }
    }

    public <T> T fromDifferentJson(String differentJson, Class<T> classOfT) throws JSONException, JsonSyntaxException, IllegalArgumentException {
        JSONObject jsonObject = new JSONObject(differentJson);
        if (jsonObject.optInt("code") == 200) {
            try {
                return (T)new Gson().fromJson(differentJson, classOfT);
            }
            catch (JsonSyntaxException e) {
                throw new JsonSyntaxException(differentJson + " - " + e.getMessage());
            }
        }
        throw new IllegalArgumentException(jsonObject.optString("message"));
    }

    public <T> T forceCommonJson(String differentJson, Class<T> classOfT) throws JsonSyntaxException {
        try {
            return (T)new Gson().fromJson(differentJson, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new JsonSyntaxException(differentJson + " - " + (Object)((Object)e));
        }
    }

    public abstract T generateT(String var1) throws JSONException, JsonSyntaxException, IllegalArgumentException;

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        if (this.listener != null) {
            this.listener.fail(t);
        }
    }
}

