/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.danmaku;

import java.util.Locale;

public class DanmakuTool {
    private static String generateTime(long milliseconds) {
        int totalSeconds = (int)(milliseconds / 1000L);
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        if (hours > 0) {
            return String.format(Locale.US, "%02d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return String.format(Locale.US, "%02d:%02d:%02d", 0, minutes, seconds).toString();
    }

    public static String secondToOriginal(String second) {
        return DanmakuTool.generateTime(Long.parseLong(second) * 1000L);
    }

    public static String fontModeToOriginal(String fontMode) {
        if (fontMode.equals("5")) {
            return "top";
        }
        if (fontMode.equals("4")) {
            return "bottom";
        }
        return "roll";
    }

    public static String fontColorToOriginal(int fontColor) {
        return "0x" + Integer.toHexString(fontColor).toUpperCase();
    }

    public static String fontColorToRGB(String fontColor) {
        return "0xFF" + fontColor.substring(2);
    }

    public static String timeToSecond(String time) {
        if (time.equals("0")) {
            time = "00:00:00";
        }
        String[] str = time.split(":");
        int hour = Integer.parseInt(str[0]);
        int minute = Integer.parseInt(str[1]);
        int seconds = Integer.parseInt(str[2]);
        return hour * 3600 + minute * 60 + seconds + "";
    }

    public static int fontModeToCanResolve(String fontMode) {
        if (fontMode.equals("top")) {
            return 5;
        }
        if (fontMode.equals("bottom")) {
            return 4;
        }
        return 1;
    }

    public static String fontColorToRGB(int fontColor) {
        String hex = Integer.toHexString(fontColor);
        if (hex.length() < "FFFFFFFF".length()) {
            return "0xFFFFFF";
        }
        return "0x" + hex.substring(2).toUpperCase();
    }

    public static int fontColorToCanResolveInt(String fontColor) {
        return Integer.parseInt(fontColor.substring(2), 16);
    }

    public static String fontColorToCanResolve(String fontColor) {
        return Integer.parseInt(fontColor.substring(2), 16) + "";
    }
}

