package com.easefun.polyvsdk.sub.vlms.entity;

import java.util.List;

/**
 * 网校课程的问题信息
 */
public class PolyvQuestionInfo {
    public Data data;
    public String message;
    public String status;
    public int code;

    public class Data {
        public int question_size;
        public int page_size;
        public int next_page_number;
        public boolean is_last_page;
        public int total_items;
        public boolean has_next_page;
        public boolean is_first_page;
        public int page_number;
        public int total_pages;
        public List<Question> questions;
        public String school_id;
        public boolean has_pre_page;

        @Override
        public String toString() {
            return "Data{" +
                    "question_size=" + question_size +
                    ", page_size=" + page_size +
                    ", next_page_number=" + next_page_number +
                    ", is_last_page=" + is_last_page +
                    ", total_items=" + total_items +
                    ", has_next_page=" + has_next_page +
                    ", is_first_page=" + is_first_page +
                    ", page_number=" + page_number +
                    ", total_pages=" + total_pages +
                    ", questions=" + questions +
                    ", school_id='" + school_id + '\'' +
                    ", has_pre_page=" + has_pre_page +
                    '}';
        }
    }

    public static class Question {
        public String content;
        public String title;
        public String last_modified;
        public String nickname;
        public String date_added;
        public int answer_count;
        public String user_id;
        public String course_id;
        public String question_id;
        public String avatar;
        public String school_id;

        @Override
        public String toString() {
            return "Question{" +
                    "content='" + content + '\'' +
                    ", title='" + title + '\'' +
                    ", last_modified='" + last_modified + '\'' +
                    ", nickname='" + nickname + '\'' +
                    ", date_added='" + date_added + '\'' +
                    ", answer_count=" + answer_count +
                    ", user_id='" + user_id + '\'' +
                    ", course_id='" + course_id + '\'' +
                    ", question_id='" + question_id + '\'' +
                    ", avatar='" + avatar + '\'' +
                    ", school_id='" + school_id + '\'' +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "PolyvQuestionInfo{" +
                "data=" + data +
                ", message='" + message + '\'' +
                ", status='" + status + '\'' +
                ", code=" + code +
                '}';
    }
}
