package com.easefun.polyvsdk.sub.vlms.entity;

import java.util.List;

/**
 * 网校课程的课时信息
 */
public class PolyvCurriculumInfo {
    public static final String TYPE_VIDEO = "VIDEO";
    public static final String TYPE_TEXT = "TEXT";
    public static final String TYPE_LIVE = "LIVE";
    public Data data;
    public String message;
    public String status;
    public int code;

    public class Data {
        public String school_id;
        public String course_type;
        public List<Section> sections;
        public String course_id;

        @Override
        public String toString() {
            return "Data{" +
                    "school_id='" + school_id + '\'' +
                    ", course_type='" + course_type + '\'' +
                    ", sections=" + sections +
                    ", course_id='" + course_id + '\'' +
                    '}';
        }
    }

    /**
     * 章节
     */
    public class Section {
        public String status;
        public String title;
        public String section_id;
        public List<Lecture> lectures;

        @Override
        public String toString() {
            return "Section{" +
                    "status='" + status + '\'' +
                    ", title='" + title + '\'' +
                    ", section_id='" + section_id + '\'' +
                    ", lectures=" + lectures +
                    '}';
        }
    }

    /**
     * 课时
     */
    public class Lecture {
        public String title;
        public String lecture_id;
        public String duration;
        public String status;
        public String flv;
        public String mp4;
        public String video_title;
        public String type;
        public String vid;
        public boolean free_preview;
        public String start_time;
        public String end_time;
        public String text;

        @Override
        public String toString() {
            return "Lecture{" +
                    "title='" + title + '\'' +
                    ", lecture_id='" + lecture_id + '\'' +
                    ", duration='" + duration + '\'' +
                    ", status='" + status + '\'' +
                    ", flv='" + flv + '\'' +
                    ", mp4='" + mp4 + '\'' +
                    ", video_title='" + video_title + '\'' +
                    ", type='" + type + '\'' +
                    ", vid='" + vid + '\'' +
                    ", free_preview=" + free_preview +
                    ", start_time='" + start_time + '\'' +
                    ", end_time='" + end_time + '\'' +
                    ", text='" + text + '\'' +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "PolyvCurriculumInfo{" +
                "data=" + data +
                ", message='" + message + '\'' +
                ", status='" + status + '\'' +
                ", code=" + code +
                '}';
    }
}
