package com.easefun.polyvsdk.sub.vlms.entity;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;

/**
 * 网校的课程信息
 */
public class PolyvCoursesInfo {
    public static final String IS_FREE_YES = "Y";
    public static final String IS_FREE_NO = "N";
    public static final String TYPE_RECOMMEND = "RECOMMEND";
    public static final String TYPE_POPULAR = "POPULAR";
    public static final String TYPE_DEFAULT = "DEFAULT";
    public static final String COURSE_TYPE_VOD = "VOD";
    public static final String COURSE_TYP_LIVE = "LIVE";
    public Data data;
    public String message;
    public String status;
    public int code;

    public class Data {
        public int page_size;
        public int next_page_number;
        public boolean is_last_page;
        public List<Course> courses;
        public int total_items;
        public boolean has_next_page;
        public boolean is_first_page;
        public int page_number;
        public int total_pages;
        public int course_size;
        public String school_id;
        public boolean has_pre_page;

        @Override
        public String toString() {
            return "Data{" +
                    "page_size=" + page_size +
                    ", next_page_number=" + next_page_number +
                    ", is_last_page=" + is_last_page +
                    ", courses=" + courses +
                    ", total_items=" + total_items +
                    ", has_next_page=" + has_next_page +
                    ", is_first_page=" + is_first_page +
                    ", page_number=" + page_number +
                    ", total_pages=" + total_pages +
                    ", course_size=" + course_size +
                    ", school_id='" + school_id + '\'' +
                    ", has_pre_page=" + has_pre_page +
                    '}';
        }
    }

    /**
     * 课程
     */
    public static class Course implements Parcelable {
        /**
         * 概述
         */
        public String summary;
        public int avg_rating;
        /**
         * 封面图
         */
        public String cover_image;
        public int review_count;
        public String keyword;
        public String category_id;
        public String title;
        public float price;
        public String is_free_vip;
        public int validity;
        public int student_count;
        public String subtitle;
        /**
         * 课程id
         */
        public String course_id;
        public String course_type;
        public String is_free;

        @Override
        public String toString() {
            return "Course{" +
                    "summary='" + summary + '\'' +
                    ", avg_rating=" + avg_rating +
                    ", cover_image='" + cover_image + '\'' +
                    ", review_count=" + review_count +
                    ", keyword='" + keyword + '\'' +
                    ", category_id='" + category_id + '\'' +
                    ", title='" + title + '\'' +
                    ", price=" + price +
                    ", is_free_vip='" + is_free_vip + '\'' +
                    ", validity=" + validity +
                    ", student_count=" + student_count +
                    ", subtitle='" + subtitle + '\'' +
                    ", course_id='" + course_id + '\'' +
                    ", course_type='" + course_type + '\'' +
                    ", is_free='" + is_free + '\'' +
                    '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(course_id);
            dest.writeString(summary);
            dest.writeString(title);
            dest.writeString(is_free);
            dest.writeFloat(price);
            dest.writeInt(student_count);
            dest.writeString(cover_image);
        }

        public static final Creator<Course> CREATOR = new Creator<Course>() {

            @Override
            public Course[] newArray(int size) {
                return new Course[size];
            }

            @Override
            public Course createFromParcel(Parcel source) {
                Course course = new Course();
                // 顺序要一致
                course.course_id = source.readString();
                course.summary = source.readString();
                course.title = source.readString();
                course.is_free = source.readString();
                course.price = source.readFloat();
                course.student_count = source.readInt();
                course.cover_image = source.readString();
                return course;
            }
        };
    }

    @Override
    public String toString() {
        return "PolyvCoursesInfo{" +
                "data=" + data +
                ", message='" + message + '\'' +
                ", status='" + status + '\'' +
                ", code=" + code +
                '}';
    }
}
