package com.easefun.polyvsdk.sub.danmaku.entity;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringDef;

import com.easefun.polyvsdk.sub.danmaku.auxiliary.PolyvDanmakuTransfer;

import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * 弹幕信息类
 */
public class PolyvDanmakuInfo implements Serializable{
    public static final String FONTSIZE_LARGE = "24";
    public static final String FONTSIZE_MIDDLE = "18";
    public static final String FONTSIZE_SMALL = "16";
    public static final String FONTMODE_ROLL = "roll";
    public static final String FONTMODE_TOP = "top";
    public static final String FONTMODE_BOTTOM = "bottom";
    private String msg;
    private String time;
    private String fontSize;
    private String fontMode;
    private String fontColor;
    private String timestamp;
    public String vid;

    @StringDef({FONTSIZE_LARGE, FONTSIZE_MIDDLE, FONTSIZE_SMALL})
    @Retention(RetentionPolicy.SOURCE)
    public @interface FontSize {
    }

    @StringDef({FONTMODE_ROLL, FONTMODE_TOP, FONTMODE_BOTTOM})
    @Retention(RetentionPolicy.SOURCE)
    public @interface FontMode {
    }

    public PolyvDanmakuInfo(@NonNull String vid, @NonNull String msg, @NonNull String time) {
        this(vid, msg, time, FONTSIZE_MIDDLE, FONTMODE_ROLL, Color.WHITE);
    }

    /**
     * @param vid       视频vid
     * @param msg       弹幕信息
     * @param time      弹幕出现时间 格式：01:03:05
     * @param fontSize  字体的大小 取值有：16,18,24 默认为18
     * @param fontMode  弹幕的样式 取值有：top，bottom，roll 默认为roll
     * @param fontColor 字体颜色 默认为Color.WHITE
     */
    public PolyvDanmakuInfo(@NonNull String vid, @NonNull String msg, @NonNull String time, @FontSize String fontSize, @FontMode String fontMode, @ColorInt int fontColor) {
        this.vid = PolyvDanmakuTransfer.checkVid(vid);
        this.msg = PolyvDanmakuTransfer.checkMsg(msg);
        this.time = PolyvDanmakuTransfer.checkTime(time);
        this.fontSize = PolyvDanmakuTransfer.checkFontSizeTransfer(fontSize);
        this.fontMode = PolyvDanmakuTransfer.checkFontModeTransfer(fontMode);
        this.fontColor = PolyvDanmakuTransfer.checkFontColorTransfer(fontColor);
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getFontSize() {
        return fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontMode() {
        return fontMode;
    }

    public void setFontMode(String fontMode) {
        this.fontMode = fontMode;
    }

    public String getFontColor() {
        return fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "PolyvDanmakuInfo{" +
                "msg='" + msg + '\'' +
                ", time='" + time + '\'' +
                ", fontSize='" + fontSize + '\'' +
                ", fontMode='" + fontMode + '\'' +
                ", fontColor='" + fontColor + '\'' +
                ", timestamp='" + timestamp + '\'' +
                '}';
    }
}
