package com.easefun.polyvsdk.sub.auxilliary.cache.auxiliary;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import com.easefun.polyvsdk.sub.auxilliary.LogUtil;

public class AppHelper {

    private AppHelper() {
        /* cannot be instantiated */
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    private static PackageInfo getPackageiInfo(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            return packageManager.getPackageInfo(context.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            LogUtil.w("getPackageiInfo", e);
        }
        return null;
    }

    /**
     * 获取应用程序名称
     */
    public static String getAppName(Context context) {
        PackageInfo packageInfo = getPackageiInfo(context);
        if (packageInfo != null) {
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        return null;
    }

    /**
     * [获取应用程序版本名称信息]
     *
     * @param context
     * @return 当前应用的版本名称
     */
    public static String getVersionName(Context context) {
        PackageInfo packageInfo = getPackageiInfo(context);
        if (packageInfo != null)
            return packageInfo.versionName;
        return null;
    }

    /**
     * [获取应用程序版本号]
     *
     * @param context
     * @return 当前应用的版本号
     */
    public static int getVersionCode(Context context) {
        PackageInfo packageInfo = getPackageiInfo(context);
        if (packageInfo != null)
            return packageInfo.versionCode;
        return 1;
    }
}
