package com.easefun.polyvsdk.sub.auxilliary;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;

import org.json.JSONException;
import org.json.JSONObject;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

// json数据在成功和失败的时候数据不同时
public abstract class DifferentCallback<T> implements retrofit2.Callback<ResponseBody> {
    public IListener<T> listener;

    public DifferentCallback(IListener<T> listener) {
        this.listener = listener;
    }

    @Override
    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        int code = response.code();
        if (code != 200 && code != 206) {
            onFailure(call, new Exception("response code is " + code));
            return;
        }
        if (listener != null)
            try {
                listener.success(generateT(response.body().string()));
            } catch (Exception e) {
                onFailure(call, e);
            }
    }

    // 根据vlms接口数据中的code和message来获取其实体类，并可以根据返回的信息去回调成功或失败
    public <T> T fromDifferentJson(String differentJson, Class<T> classOfT) throws JSONException, JsonSyntaxException, IllegalArgumentException {
        JSONObject jsonObject = new JSONObject(differentJson);
        if (jsonObject.optInt("code") == 200) {
            try {
                return new Gson().fromJson(differentJson, classOfT);
            } catch (JsonSyntaxException e) {
                throw new JsonSyntaxException(differentJson + " - " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException(jsonObject.optString("message"));
        }
    }

    // 当成功与失败的json数据格式不一致时，会抛出带返回信息的异常
    public <T> T forceCommonJson(String differentJson, Class<T> classOfT) throws JsonSyntaxException {
        try {
            return new Gson().fromJson(differentJson, classOfT);
        } catch (JsonSyntaxException e) {
            throw new JsonSyntaxException(differentJson + " - " + e);
        }
    }

    public abstract T generateT(String differentJson) throws JSONException, JsonSyntaxException, IllegalArgumentException;

    @Override
    public void onFailure(Call<ResponseBody> call, Throwable t) {
        if (listener != null)
            listener.fail(t);
    }
}
