package com.easefun.polyvsdk.screenshot;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.widget.Toast;

import java.io.File;

/**
 * 发送广播及有关Activity操作工具类
 *
 */
public class ActivityTool {

	/**
	 *  在UI线程显示toast
	 * @param activity
	 * @param msg
	 */
	public static void toastMsg(final Activity activity, final String msg) {
		activity.runOnUiThread(new Runnable() {

			@Override
			public void run() {
				Toast.makeText(activity, msg, Toast.LENGTH_SHORT).show();
			}
		});
	}

	/**
	 *  在UI线程显示toast
	 * @param activity
	 * @param msg
	 */
	public static void toastMsg(final Context activity, final String msg) {
		if (activity instanceof Activity) {
			((Activity) activity).runOnUiThread(new Runnable() {

				@Override
				public void run() {
					Toast.makeText(activity, msg, Toast.LENGTH_SHORT).show();
				}
			});
		}
	}

	/**
	 *  发送sd卡就绪广播,仅支持内置sd卡
	 * @param context
	 * @param filepath
	 * @deprecated
	 */
	public static void sendSdCardReady(Context context, String filepath) {
		if (filepath == null)
			filepath = Environment.getExternalStorageDirectory().getAbsolutePath();
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
			// 如果是4.4及以上版本
			Intent mediaScanIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);
			// 只能是文件路径，不能是目录
			Uri contentUri = Uri.fromFile(new File(filepath));
			mediaScanIntent.setData(contentUri);
			context.sendBroadcast(mediaScanIntent);
		} else {
			context.sendBroadcast(new Intent(Intent.ACTION_MEDIA_MOUNTED,
					Uri.parse("file://" + Environment.getExternalStorageDirectory())));
		}
	}
}
