package com.easefun.polyvsdk.danmaku;

import java.util.ArrayList;
import java.util.List;

public class DanmakuTempMyself {
	private static List<DanmakuInfo> danmakuInfos = new ArrayList<DanmakuInfo>();

	/**
	 * 获取自己的临时弹幕
	 * 
	 * @return
	 */
	public synchronized static List<DanmakuInfo> getTempDanmaku() {
		return danmakuInfos;
	}

	/**
	 * 获取最后一条自己发送的弹幕
	 * 
	 * @return
	 */
	public synchronized static DanmakuInfo getLastDanmaku() {
		return danmakuInfos.get(danmakuInfos.size() - 1);
	}

	/**
	 * 添加自己的临时弹幕
	 * 
	 * @param danmakuInfo
	 */
	public synchronized static void addTempDanmaku(DanmakuInfo danmakuInfo) {
		danmakuInfo.setTime(DanmakuTool.timeToSecond(danmakuInfo.getTime()));
		danmakuInfo.setFontMode(DanmakuTool.fontModeToCanResolve(danmakuInfo.getFontMode()) + "");
		danmakuInfo.setFontColor(
				DanmakuTool.fontColorToCanResolveInt(DanmakuTool.fontColorToRGB(danmakuInfo.getFontColor())));
		danmakuInfos.add(danmakuInfo);
	}

	/**
	 * 移除一条自己的临时弹幕
	 * 
	 * @param danmakuInfo
	 */
	public synchronized static void removeTempDanmaku(DanmakuInfo danmakuInfo) {
		danmakuInfos.remove(danmakuInfo);
	}

	/**
	 * 清空自己的临时弹幕
	 */
	public synchronized static void clearTempDanmaku() {
		danmakuInfos.clear();
	}
}
