package com.easefun.polyvsdk.danmaku;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * 获取新弹幕的类
 *
 */
public class DanmakuNewMsg implements DanmakuException {
	// 是否要更新最新一次的弹幕数据
	private boolean isnewget;
	// 调用getDanmakuByServer或getNewDanmaku最新一次的弹幕数据
	private DanmakuInfo serPreNewdanmaku;

	/**
	 * @param serPreNewdanmaku
	 *            前一次从服务器获取到的弹幕
	 */
	public DanmakuNewMsg(DanmakuInfo serPreNewdanmaku) {
		this.serPreNewdanmaku = serPreNewdanmaku;
	}

	private NewMsgListener newMsgListener;

	public void setNewMsgListener(NewMsgListener newMsgListener) {
		this.newMsgListener = newMsgListener;
	}

	/**
	 * 新弹幕的监听器
	 *
	 */
	public interface NewMsgListener {
		public void success(List<DanmakuInfo> lists);

		public void fail(int category);
	}

	private void callSuccess(List<DanmakuInfo> lists) {
		if (newMsgListener != null)
			newMsgListener.success(lists);
	}

	private void callFail(int category) {
		if (newMsgListener != null)
			newMsgListener.fail(category);
	}

	/**
	 * 从服务器中获取新的弹幕，该方法可能会阻塞UI线程，建议放到子线程中执行
	 * 
	 * @param vid
	 *            视频的id
	 * @param limit
	 *            限制拿取的新弹幕数
	 * @return List<DanmakuInfo> 获取到的新的弹幕数据,没有数据或者发生异常时返回null
	 */
	public List<DanmakuInfo> getNewDanmaku(String vid, int limit) {
		isnewget = false;
		List<DanmakuInfo> newDanmaku = null;
		if (serPreNewdanmaku != null) {
			newDanmaku = getDanmakuList(getJson(vid, limit), vid, false);
			if (newDanmaku != null)
				Collections.reverse(newDanmaku);
			return newDanmaku;
		} else {
			newDanmaku = getDanmakuList(getJson(vid, limit), vid, true);
			if (newDanmaku != null)
				Collections.reverse(newDanmaku);
			return newDanmaku;
		}
	}

	// 解析json获取List<DanmakuInfo>
	private List<DanmakuInfo> getDanmakuList(String json, String vid, boolean isnull) {
		if (json == null) {
			callFail(NETWORK_EXCEPTION);
			return null;
		}
		if (json.equals("")) {
			callFail(VIDEO_NOT_DANMAKU);
			return null;
		}
		if (json.equals(" ")) {
			callFail(RESPONSE_FAIL);
			return null;
		}
		List<DanmakuInfo> lists = new ArrayList<>();
		try {
			JSONArray jsonArray = new JSONArray(json);
			for (int i = 0; i < jsonArray.length(); i++) {
				JSONObject jsonObject = (JSONObject) jsonArray.opt(i);
				String time = jsonObject.getString("time");
				String fontMode = jsonObject.getString("fontMode");
				String fontSize = jsonObject.getString("fontSize");
				String fontColor = jsonObject.getString("fontColor");
				String msg = jsonObject.getString("msg");
				String timestamp = jsonObject.getString("timestamp");
				// 改变时间的格式
				time = DanmakuTool.timeToSecond(time);
				// 改变弹幕的格式
				fontMode = DanmakuTool.fontModeToCanResolve(fontMode) + "";
				// 改变为解析器弹幕的颜色
				fontColor = DanmakuTool.fontColorToCanResolve(fontColor);
				DanmakuInfo danmaku = new DanmakuInfo(vid, msg, time, Integer.parseInt(fontSize), fontMode,
						Integer.parseInt(fontColor), timestamp, "1", "1");
				if (!isnewget && isnull) {
					serPreNewdanmaku = danmaku;
					isnewget = !isnewget;
				} else if (danmaku.compareTo(serPreNewdanmaku) == 0) {
					if (lists.size() == 0) {
						callFail(VIDEO_NOT_NEW_DANMAKU);
						return null;
					}
					break;
				}
				lists.add(danmaku);
			}
			if (!isnull && lists.size() > 0)
				serPreNewdanmaku = lists.get(0);
			callSuccess(lists);
			return lists;
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}

	// 连接服务器，获取json
	private String getJson(final String vid, final int limit) {
		ExecutorService executorService = Executors.newSingleThreadExecutor();
		Future<String> future = executorService.submit(new Callable<String>() {

			@Override
			public String call() {
				StringBuilder sb = new StringBuilder();
				sb.append("?vid=").append(vid);
				if (limit > 0)
					sb.append("&limit=").append(limit);
				HttpURLConnection conn = null;
				try {
					URL url = new URL("http://go.polyv.net/admin/printjson.php" + sb.toString());
					conn = (HttpURLConnection) url.openConnection();
					conn.setRequestMethod("GET");
					conn.setConnectTimeout(30000);
					if (conn.getResponseCode() == 200) {
						BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
						String json = null;
						if ((json = in.readLine()) != null && json.length() > 2)
							return json;
						else
							return "";
					} else {
						return " ";
					}
				} catch (MalformedURLException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				} finally {
					conn.disconnect();
				}
				return null;
			}
		});
		try {
			return future.get();
		} catch (InterruptedException | ExecutionException e) {
			e.printStackTrace();
		} finally {
			if (executorService != null)
				executorService.shutdown();
			executorService = null;
		}
		return null;
	}
}