package com.easefun.polyvsdk.danmaku;

import android.annotation.SuppressLint;
import android.graphics.Color;
import android.os.Handler;
import android.util.Log;

import com.easefun.polyvsdk.ijk.IjkVideoView;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.loader.ILoader;
import master.flame.danmaku.danmaku.loader.IllegalDataException;
import master.flame.danmaku.danmaku.loader.android.DanmakuLoaderFactory;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.IDataSource;

/**
 * 请使用{@link com.easefun.polyvsdk.sub.danmaku.main.PolyvDanmakuManager}代替。
 * @see com.easefun.polyvsdk.sub.danmaku.main.PolyvDanmakuManager
 */
@Deprecated
public class DanmakuManager implements DanmakuException {
	private static final String TAG = "DanmakuManager";
	private static final int SHOWNEWDANMAKU = 0;
	private static final int DELAYTIME = 5000;
	private String vid;
	private String msg;
	private String time;
	private int fontSize;
	private String fontMode;
	private int fontColor;
	// 要发送的弹幕
	private DanmakuInfo sendDanmaku;
	// 从服务器获取到要解析为流的弹幕
	private List<DanmakuInfo> getDanmakus;

	// 调用getDanmakuByServer获取到的最新一次的弹幕数据
	private DanmakuInfo serPreNewDanmaku;
	// 调用getDanmakuByServer或getNewDanmaku最新一次的弹幕数据
	private DanmakuInfo preNewdanmaku;
	// 是否要更新最新一次的弹幕数据
	private boolean isget;
	// 获取新的弹幕的计时器
	private Timer timer;
	private TimerTask timerTask;
	// 获取到的新的且还没有显示的弹幕
	private List<DanmakuInfo> notshows;

	private IDanmakuView mDanmakuView;
	private BaseDanmakuParser mParser;
	private DanmakuContext mContext;
	private IjkVideoView videoView;
	private boolean isset;
	private boolean isshow;
	private boolean ishandleshow;

	@SuppressLint("HandlerLeak")
	private Handler handler = new Handler() {
		public void handleMessage(android.os.Message msg) {
			for (int i = 0; i < notshows.size(); i++) {
				if (Integer.parseInt(notshows.get(i).getTime()) == videoView.getCurrentPosition() / 1000) {
					if (DanmakuTempMyself.getTempDanmaku().size() == 0) {
						setSendDanmaku(notshows.get(i));
						showDanmaku(mDanmakuView, mParser, mContext, false, true);
						notshows.remove(i);
					} else {
						for (DanmakuInfo temp : DanmakuTempMyself.getTempDanmaku()) {
							if (temp.getTimestamp().equals("1")) {
								temp.setTimestamp(notshows.get(i).getTimestamp());
							}
							if (notshows.get(i).compareTo(temp) == 0) {
								DanmakuTempMyself.removeTempDanmaku(temp);
								notshows.remove(i);
								ishandleshow = false;
								break;
							} else {
								ishandleshow = true;
								continue;
							}
						}
						if (ishandleshow) {
							setSendDanmaku(notshows.get(i));
							showDanmaku(mDanmakuView, mParser, mContext, false, true);
							notshows.remove(i);
						}
					}
				}
			}
			if (notshows.size() == 0) {
				handler.removeMessages(SHOWNEWDANMAKU);
			} else {
				handler.sendEmptyMessageDelayed(SHOWNEWDANMAKU, 1000);
			}
		};
	};

	/**
	 * 释放资源
	 */
	public void release() {
		DanmakuTempMyself.clearTempDanmaku();
		if (timer != null) {
			timer.cancel();
		}
		handler.removeMessages(SHOWNEWDANMAKU);
	}

	/**
	 * 返回最新获取到的一条弹幕
	 */
	public DanmakuInfo getSerPreNewDanmaku() {
		return serPreNewDanmaku;
	}

	/**
	 * 设置发送的弹幕
	 * 
	 * @param sendDanmaku
	 *            要发送的弹幕
	 */
	public void setSendDanmaku(DanmakuInfo sendDanmaku) {
		this.sendDanmaku = sendDanmaku;
		this.vid = sendDanmaku.getVid();
		this.msg = sendDanmaku.getMsg();
		this.time = sendDanmaku.getTime();
		this.fontSize = sendDanmaku.getFontSize();
		this.fontMode = sendDanmaku.getFontMode();
		this.fontColor = sendDanmaku.getFontColor();
	}

	// 发送弹幕的监听器
	public interface SendDanmakuListener {
		public void fail(int category);

		public void success();
	}

	private SendDanmakuListener sendDanmakuListener;

	public void setSendDanmakuListener(SendDanmakuListener sendDanmakuListener) {
		this.sendDanmakuListener = sendDanmakuListener;
	}

	// 失败的信息回调
	private void callFail(int category) {
		if (sendDanmakuListener != null)
			sendDanmakuListener.fail(category);
	}

	// 成功的信息回调
	private void callSuccess() {
		if (sendDanmakuListener != null)
			sendDanmakuListener.success();
	}

	// 获取弹幕的监听器
	public interface GetDanmakuListener {
		public void fail(int category);

		public void success(int total, List<DanmakuInfo> getDanmakus);
	}

	private GetDanmakuListener getDanmakuListener;

	public void setGetDanmakuListener(GetDanmakuListener getDanmakuListener) {
		this.getDanmakuListener = getDanmakuListener;
	}

	// 获取失败的信息回调
	private void callFail_get(int category) {
		if (getDanmakuListener != null)
			getDanmakuListener.fail(category);
	}

	// 获取成功的信息回调
	private void callSuccess_get(int total, List<DanmakuInfo> getDanmakus) {
		if (getDanmakuListener != null)
			getDanmakuListener.success(total, getDanmakus);
	}

	/**
	 * 从服务器中获取新增的弹幕和显示,从服务器中获取弹幕，该方法可能会阻塞UI线程，建议放到子线程中执行。由于没有userid/时间戳进行判断，
	 * 当在视频的同一秒存在和自己发的弹幕相等时将不会显示
	 * 
	 * @param vid
	 *            视频的id
	 * @param limit
	 *            限制拿取的弹幕数
	 * @param milliseconds
	 *            调用间隔，毫秒
	 * @param mDanmakuView
	 *            弹幕的view
	 * @param mParser
	 *            弹幕的解析器
	 * @param mContext
	 *            弹幕的上下文
	 * @param videoView
	 *            视频的view
	 */
	public void getNewDanmakuAndShow(final String vid, final int limit, int milliseconds,
			final IDanmakuView mDanmakuView, final BaseDanmakuParser mParser, final DanmakuContext mContext,
			final IjkVideoView videoView) {
		timer = new Timer(true);
		timerTask = new TimerTask() {

			@Override
			public void run() {
				if (!isset) {
					if (vid == null || mDanmakuView == null || mParser == null || mContext == null || videoView == null)
						return;
					else {
						DanmakuManager.this.mDanmakuView = mDanmakuView;
						DanmakuManager.this.mParser = mParser;
						DanmakuManager.this.mContext = mContext;
						DanmakuManager.this.videoView = videoView;
						isset = !isset;
					}
				}
				List<DanmakuInfo> danmakuInfos = getNewDanmaku(vid, limit);
				if (danmakuInfos != null) {
					for (DanmakuInfo danmakuInfo : danmakuInfos) {
						if (Integer.parseInt(danmakuInfo.getTime()) == videoView.getCurrentPosition() / 1000) {
							if (DanmakuTempMyself.getTempDanmaku().size() == 0) {
								setSendDanmaku(danmakuInfo);
								showDanmaku(mDanmakuView, mParser, mContext, false, true);
							} else {
								for (DanmakuInfo temp : DanmakuTempMyself.getTempDanmaku()) {
									if (temp.getTimestamp().equals("1")) {
										temp.setTimestamp(danmakuInfo.getTimestamp());
									}
									if (danmakuInfo.compareTo(temp) == 0) {
										DanmakuTempMyself.removeTempDanmaku(temp);
										isshow = false;
										break;
									} else {
										isshow = true;
										continue;
									}
								}
								if (isshow) {
									setSendDanmaku(danmakuInfo);
									showDanmaku(mDanmakuView, mParser, mContext, false, true);
								}
							}
						} else {
							notshows.add(danmakuInfo);
							handler.sendEmptyMessage(SHOWNEWDANMAKU);
						}
					}
				}
			}
		};
		notshows = new ArrayList<>();
		timer.schedule(timerTask, DELAYTIME, milliseconds);
	}

	/**
	 * 从服务器中获取新增的弹幕和显示
	 * 
	 * @param vid
	 *            视频的id
	 * @param milliseconds
	 *            调用间隔，毫秒
	 * @param mDanmakuView
	 *            弹幕的view
	 * @param mParser
	 *            弹幕的解析器
	 * @param mContext
	 *            弹幕的上下文
	 * @param videoView
	 *            视频的view
	 */
	public void getNewDanmakuAndShow(String vid, int milliseconds, IDanmakuView mDanmakuView, BaseDanmakuParser mParser,
			DanmakuContext mContext, IjkVideoView videoView) {
		getNewDanmakuAndShow(vid, 0, milliseconds, mDanmakuView, mParser, mContext, videoView);
	}

	/**
	 * 从服务器中获取新的弹幕，该方法可能会阻塞UI线程，建议放到子线程中执行,由于该方法和获取并显示的方法冲突，所以不对外提供
	 * 
	 * @param vid
	 *            视频的id
	 * @param limit
	 *            限制拿取的新弹幕数
	 * @return List<DanmakuInfo> 获取到的新的弹幕数据,没有数据或者发生异常时返回null
	 */
	private List<DanmakuInfo> getNewDanmaku(String vid, int limit) {
		isget = false;
		if (preNewdanmaku != null) {
			return getDanmakuList(getJson(vid, limit), vid, false);
		} else {
			return getDanmakuList(getJson(vid, limit), vid, true);
		}
	}

	/**
	 * 获取弹幕解析器
	 * 
	 * @param stream
	 */
	public BaseDanmakuParser getBaseDanmakuParser(InputStream stream) {
		if (stream == null) {
			return new BaseDanmakuParser() {

				@Override
				protected Danmakus parse() {
					return new Danmakus();
				}
			};
		}

		ILoader loader = DanmakuLoaderFactory.create(DanmakuLoaderFactory.TAG_BILI);

		try {
			loader.load(stream);
		} catch (IllegalDataException e) {
			e.printStackTrace();
		}
		BaseDanmakuParser parser = new BiliDanmukuParser();
		IDataSource<?> dataSource = loader.getDataSource();
		parser.load(dataSource);
		return parser;
	}

	/**
	 * 将弹幕显示在屏幕上
	 * 
	 * @param mDanmakuView
	 * @param mParser
	 * @param mContext
	 * @param hasunderlineColor
	 *            是否有下划线，默认为true
	 * @param ignoremode
	 *            是否忽略fontmode的格式，默认为false
	 */
	public void showDanmaku(IDanmakuView mDanmakuView, BaseDanmakuParser mParser, DanmakuContext mContext,
			boolean hasunderlineColor, boolean ignoremode) {
		if (sendDanmaku == null)
			return;
		if (msg == null || msg.trim().equals(""))
			return;
		if (fontSize != 16 && fontSize != 18 && fontSize != 24)
			fontSize = 18;
		if ((fontColor | 0xFF000000) > (Color.WHITE | 0xFF000000)
				|| (fontColor | 0xFF000000) < (Color.BLACK | 0xFF000000))
			fontColor = Color.WHITE;
		if (ignoremode) {
			int mode = Integer.parseInt(fontMode);
			switch (mode) {
			case BaseDanmaku.TYPE_SCROLL_RL:
				fontMode = "roll";
				break;
			case BaseDanmaku.TYPE_FIX_TOP:
				fontMode = "top";
				break;
			case BaseDanmaku.TYPE_FIX_BOTTOM:
				fontMode = "bottom";
				break;
			}
		} else if (fontMode == null
				|| (!fontMode.equals("top") && !fontMode.equals("bottom") && !fontMode.equals("roll")))
			fontMode = "roll";
		if (mDanmakuView != null && mParser != null && mContext != null) {
			BaseDanmaku danmaku = mContext.mDanmakuFactory.createDanmaku(DanmakuTool.fontModeToCanResolve(fontMode));
			danmaku.padding = 0;
			danmaku.borderColor = 0;
			if (hasunderlineColor)
				danmaku.underlineColor = Color.GREEN;
			else
				danmaku.underlineColor = 0;
			showBaseDanmaku(mDanmakuView, mParser, danmaku);
		} else {
			Log.e(TAG, "mDanmakuView或mParser或mContext为null");
		}
	}

	/**
	 * 将弹幕显示在屏幕上
	 * 
	 * @param mDanmakuView
	 * @param mParser
	 * @param mContext
	 */
	public void showDanmaku(IDanmakuView mDanmakuView, BaseDanmakuParser mParser, DanmakuContext mContext) {
		showDanmaku(mDanmakuView, mParser, mContext, true, false);
	}

	// 显示基本样式的弹幕
	private void showBaseDanmaku(IDanmakuView mDanmakuView, BaseDanmakuParser mParser, BaseDanmaku danmaku) {
		if (msg.contains("\n")) {
			String[] msgs = msg.split("\n");
			danmaku.lines = msgs;
		} else if (msg.contains("\\n")) {
			// 使弹幕字符\n为换行，字符\\n为字符\n，解决方法：先将所有的\\n转为//n再用\\\\n切割，最后将\\n转回字符\n即可。(但当同时出现\\n和//n时，会将所有的//n转为字符\n)
			if (!msg.contains("\\\\n")) {
				String[] msgs = msg.split("\\\\n");
				danmaku.lines = msgs;
			} else {
				int index = -1;
				String nmsg = msg;
				char[] arr = msg.toCharArray();
				while ((index = nmsg.indexOf("\\\\n")) != -1) {
					nmsg = nmsg.substring(index + 3);
					int length = nmsg.length();
					for (int i = 1; i <= msg.length() - length; i++) {
						nmsg = "0" + nmsg;
					}
					arr[index] = '/';
					arr[index + 1] = '/';
					arr[index + 2] = 'n';
				}
				String rmsg = new String(arr);
				if (rmsg.contains("\\n")) {
					String[] msgs = rmsg.split("\\\\n");
					for (int i = 0; i < msgs.length; i++) {
						if (msgs[i].contains("//n")) {
							msgs[i] = msgs[i].replace("//n", "\\n");
						}
					}
					danmaku.lines = msgs;
				} else {
					danmaku.text = rmsg.replace("//n", "\\n");
				}
			}
		} else {
			danmaku.text = msg;
		}
		danmaku.isLive = false;
		danmaku.priority = 1; // 一定会显示, 一般用于本机发送的弹幕
		danmaku.setTime(mDanmakuView.getCurrentTime() + 200);;
		// fontSize * (mParser.getDisplayer().getDensity() - 0.6f)
		danmaku.textSize = fontSize * (mParser.getDisplayer().getDensity() - 0.6f);
		danmaku.textColor = fontColor;
		if (fontColor != Color.BLACK)
			danmaku.textShadowColor = Color.BLACK; // 重要：如果有图文混排，最好不要设置描边(设textShadowColor=0)，否则会进行两次复杂的绘制导致运行效率降低
		else
			danmaku.textShadowColor = Color.WHITE;
		mDanmakuView.addDanmaku(danmaku);
	}

	// 连接服务器，获取json
	private String getJson(final String vid, final int limit) {
		ExecutorService executorService = Executors.newSingleThreadExecutor();
		Future<String> future = executorService.submit(new Callable<String>() {

			@Override
			public String call() {
				StringBuilder sb = new StringBuilder();
				sb.append("?vid=").append(vid);
				HttpURLConnection conn = null;
				try {
					URL url = new URL("http://go.polyv.net/admin/printjson.php" + sb.toString());
					conn = (HttpURLConnection) url.openConnection();
					conn.setRequestMethod("GET");
					conn.setConnectTimeout(30000);
					if (conn.getResponseCode() == 200) {
						BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
						String json = null;
						if ((json = in.readLine()) != null && json.length() > 2)
							return json;
						else
							return "";
					} else {
						return " ";
					}
				} catch (MalformedURLException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				} finally {
					conn.disconnect();
				}
				return null;
			}
		});
		try {
			return future.get();
		} catch (InterruptedException | ExecutionException e) {
			e.printStackTrace();
		} finally {
			if (executorService != null)
				executorService.shutdown();
			executorService = null;
		}
		return null;
	}

	/**
	 * 从服务器中获取弹幕，该方法可能会阻塞UI线程，建议放到子线程中执行
	 * 
	 * @param vid
	 *            视频的id
	 * @param limit
	 *            限制拿取的弹幕数，当<=0时拿取全部
	 * @return InputStream 没有弹幕或发生异常时返回null
	 */
	public InputStream getDanmakuByServer(String vid, int limit) {
		return parseJson(getJson(vid, limit), vid, limit);
	}

	/**
	 * 从服务器中获取弹幕，该方法可能会阻塞UI线程，建议放到子线程中执行
	 * 
	 * @param vid
	 *            视频的id
	 * @return InputStream 没有弹幕或发生异常时返回null
	 */
	public InputStream getDanmakuByServer(String vid) {
		return getDanmakuByServer(vid, 0);
	}

	// 实时弹幕，解析json获取List<DanmakuInfo>
	private List<DanmakuInfo> getDanmakuList(String json, String vid, boolean isnull) {
		if (json == null || json.equals("") || json.equals(" "))
			return null;
		List<DanmakuInfo> lists = new ArrayList<>();
		try {
			JSONArray jsonArray = new JSONArray(json);
			for (int i = 0; i < jsonArray.length(); i++) {
				JSONObject jsonObject = (JSONObject) jsonArray.opt(i);
				String time = jsonObject.getString("time");
				String fontMode = jsonObject.getString("fontMode");
				String fontSize = jsonObject.getString("fontSize");
				String fontColor = jsonObject.getString("fontColor");
				String msg = jsonObject.getString("msg");
				String timestamp = jsonObject.getString("timestamp");
				// 改变时间的格式
				time = DanmakuTool.timeToSecond(time);
				// 改变弹幕的格式
				fontMode = DanmakuTool.fontModeToCanResolve(fontMode) + "";
				// 改变为解析器弹幕的颜色
				fontColor = DanmakuTool.fontColorToCanResolve(fontColor);
				DanmakuInfo danmaku = new DanmakuInfo(vid, msg, time, Integer.parseInt(fontSize), fontMode,
						Integer.parseInt(fontColor), timestamp, "1", "1");
				if (!isget && isnull) {
					preNewdanmaku = danmaku;
					isget = !isget;
				} else if (danmaku.compareTo(preNewdanmaku) == 0) {
					if (lists.size() == 0)
						return null;
					break;
				}
				lists.add(danmaku);
			}
			if (!isnull && lists.size() > 0)
				preNewdanmaku = lists.get(0);
			return lists;
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}

	// 解析json数据并封装对象
	private InputStream parseJson(String json, String vid, int limit) {
		if (json == null) {
			callFail_get(NETWORK_EXCEPTION);
			return null;
		}
		if (json.equals("")) {
			callFail_get(VIDEO_NOT_DANMAKU);
			return null;
		}
		if (json.equals(" ")) {
			callFail_get(RESPONSE_FAIL);
			return null;
		}
		Log.i(TAG, json);
		DanmakuXmlSerializer xmlSerializer = new DanmakuXmlSerializer();
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			xmlSerializer.setOutput(baos, "utf-8");
			xmlSerializer.startDocument("utf-8", true);
			xmlSerializer.startTag(null, "i").startTag(null, "chatserver").text("www.polyv.com")
					.endTag(null, "chatserver").startTag(null, "chatid").text("123456").endTag(null, "chatid")
					.startTag(null, "mission").text("0").endTag(null, "mission").startTag(null, "maxlimit")
					.text(limit + "").endTag(null, "maxlimit").startTag(null, "source").text("k-v")
					.endTag(null, "source");
			JSONArray jsonArray = new JSONArray(json);
			int limitNum = 0;
			if (jsonArray.length() > limit)
				limitNum = limit;
			else
				limitNum = jsonArray.length();
			getDanmakus = new ArrayList<DanmakuInfo>();
			for (int i = 0; i < limitNum; i++) {
				JSONObject jsonObject = (JSONObject) jsonArray.opt(i);
				String time = jsonObject.getString("time");
				String fontMode = jsonObject.getString("fontMode");
				String fontSize = jsonObject.getString("fontSize");
				String fontColor = jsonObject.getString("fontColor");
				String msg = jsonObject.getString("msg");
				String timestamp = jsonObject.getString("timestamp");
				// 改变时间的格式
				time = DanmakuTool.timeToSecond(time);
				// 改变弹幕的格式
				fontMode = DanmakuTool.fontModeToCanResolve(fontMode) + "";
				// 改变为解析器弹幕的颜色
				fontColor = DanmakuTool.fontColorToCanResolve(fontColor);
				DanmakuInfo danmaku = new DanmakuInfo(vid, msg, time, Integer.parseInt(fontSize), fontMode,
						Integer.parseInt(fontColor), timestamp, "1", "1");
				getDanmakus.add(danmaku);
				if (!isget) {
					preNewdanmaku = danmaku;
					serPreNewDanmaku = danmaku;
					isget = !isget;
				}
				xmlSerializer.startTag(null, "d");
				xmlSerializer.attribute(null, "p", danmaku.toString());
				xmlSerializer.text(msg);
				xmlSerializer.endTag(null, "d");
			}
			xmlSerializer.endTag(null, "i");
			xmlSerializer.endDocument();
			Log.i(TAG, baos.toString());
			Collections.reverse(getDanmakus);
			callSuccess_get(jsonArray.length(), getDanmakus);
			return new ByteArrayInputStream(baos.toByteArray());
		} catch (JSONException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalStateException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 发送弹幕信息至服务器数据库
	 * 
	 */
	public void sendDanmakuToServer() {
		if (sendDanmaku == null) {
			callFail(DANMAKUINFO_IS_NULL);
			return;
		}
		if (vid == null || vid.equals("") || msg == null || msg.trim().equals("")
				|| !time.matches("[0-9][0-9]:[0-5][0-9]:[0-5][0-9]")) {
			callFail(VID_OR_MSG_OR_TIME_ERROR);
			return;
		}
		new Thread(new Runnable() {

			@Override
			public void run() {
				StringBuilder sb = new StringBuilder();
				PrintWriter out = null;
				HttpURLConnection conn = null;
				try {
					sb.append("vid=").append(vid).append("&msg=").append(URLEncoder.encode(msg, "UTF-8"))
							.append("&time=").append(time);
					if (fontSize != 16 && fontSize != 18 && fontSize != 24)
						sb.append("&fontSize=").append(18);
					else
						sb.append("&fontSize=").append(fontSize);
					if (fontMode == null
							|| (!fontMode.equals("top") && !fontMode.equals("bottom") && !fontMode.equals("roll")))
						sb.append("&fontMode=").append("roll");
					else
						sb.append("&fontMode=").append(fontMode);
					if ((fontColor | 0xFF000000) > (Color.WHITE | 0xFF000000)
							|| (fontColor | 0xFF000000) < (Color.BLACK | 0xFF000000))
						sb.append("&fontColor=").append(DanmakuTool.fontColorToRGB(Color.WHITE));
					else
						sb.append("&fontColor=").append(DanmakuTool.fontColorToRGB(fontColor));
					URL url = new URL("http://go.polyv.net/admin/add.php");
					conn = (HttpURLConnection) url.openConnection();
					conn.setDoOutput(true);
					conn.setRequestMethod("POST");
					conn.setConnectTimeout(30000);
					out = new PrintWriter(conn.getOutputStream());
					out.print(sb.toString());
					out.flush();
					if (conn.getResponseCode() == 200) {
						// 发送成功后记录到自己的临时弹幕中,以便区分
						DanmakuTempMyself.addTempDanmaku(sendDanmaku);
						callSuccess();
						String json = new BufferedReader(new InputStreamReader(conn.getInputStream())).readLine();
						JSONObject jsonObject = new JSONObject(json);
						String timestamp = jsonObject.getString("ts");
						DanmakuTempMyself.getLastDanmaku().setTimestamp(timestamp);
					} else {
						callFail(RESPONSE_FAIL);
					}
				} catch (MalformedURLException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
					callFail(NETWORK_EXCEPTION);
				} catch (JSONException e) {
					e.printStackTrace();
				} finally {
					if (conn != null)
						conn.disconnect();
					if (out != null)
						out.close();
				}
			}
		}).start();
	}
}
