package com.easefun.polyvsdk.video.auxiliary;

import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementCountDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementEventListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementEventListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementOutListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnAuxiliaryPlayEndListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnCompletionListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnErrorListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnInfoListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnPlayPauseListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnPreparedListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnRemindCallbackListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnSeekCompleteListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnTeaserCountDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnTeaserOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoSizeChangedListener2;

import tv.danmaku.ijk.media.player.IMediaPlayer;

/**
 * @author TanQu 2016-12-6
 */
public interface IPolyvAuxiliaryVideoViewListenerEvent {
    /**
     * 设置视频播放/暂停/播放完成回调
     * @param l
     */
    public void setOnPlayPauseListener(IPolyvOnPlayPauseListener l);
    /**
     * 设置视频播放完成回调
     * @param l
     */
    public void setOnCompletionListener(IPolyvOnCompletionListener2 l);
    /**
     * 设置视频已准备好马上进入播放回调
     * @param l
     */
    public void setOnPreparedListener(IPolyvOnPreparedListener2 l);
    /**
     * 设置视频播放器内部错误回调
     * @param l
     */
    public void setOnErrorListener(IPolyvOnErrorListener2 l);
    /**
     * 设置视频播放器信息有变更回调
     * @param l
     */
    public void setOnInfoListener(IPolyvOnInfoListener2 l);
    /**
     * 设置seek完成回调
     * @param l
     */
    public void setOnSeekCompleteListener(IPolyvOnSeekCompleteListener2 l);
    /**
     * 设置视频尺寸改变回调
     * @param l
     */
    public void setOnVideoSizeChangedListener(IPolyvOnVideoSizeChangedListener2 l);
    /**
     * 设置广告弹出监听回调
     * @param l
     * @see #setOnAdvertisementOutListener(IPolyvOnAdvertisementOutListener2)
     */
    @Deprecated
    public void setOnAdvertisementOutListener(IPolyvOnAdvertisementOutListener l);
    /**
     * 设置广告弹出监听回调
     * @param l
     */
    public void setOnAdvertisementOutListener(IPolyvOnAdvertisementOutListener2 l);
    /**
     * 设置广告倒计时监听回调
     * @param l
     */
    public void setOnAdvertisementCountDownListener(IPolyvOnAdvertisementCountDownListener l);
    /**
     * 设置视频广告显示/点击监听回调
     * @param l
     * @see #setOnAdvertisementEventListener(IPolyvOnAdvertisementEventListener2)
     */
    @Deprecated
    public void setOnAdvertisementEventListener(IPolyvOnAdvertisementEventListener l);
    /**
     * 设置视频广告显示/点击监听回调
     * @param l
     */
    public void setOnAdvertisementEventListener(IPolyvOnAdvertisementEventListener2 l);
    /**
     * 设置提醒回调
     * @param l
     */
    public void setOnRemindCallback(IPolyvOnRemindCallbackListener l);
    /**
     * 设置片头弹出监听回调
     * @param l
     */
    public void setOnTeaserOutListener(IPolyvOnTeaserOutListener l);
    /**
     * 设置片头倒计时监听回调
     * @param l
     */
    public void setOnTeaserCountDownListener(IPolyvOnTeaserCountDownListener l);
    /**
     * 设置辅助播放结束监听回调
     * @param l
     */
    public void setOnAuxiliaryPlayEndListener(IPolyvOnAuxiliaryPlayEndListener l);

    //并且此四个接口对外要过期并且指引到去使用我们定义的四个替代接口，而且注释可以被外部所见，所以这里重写了接口定义。
    /**
     * Nothing to do<br/>
     * use {@link #setOnCompletionListener(IPolyvOnCompletionListener2)}
     * @param l
     */
    @Deprecated
    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener l);
    /**
     * Nothing to do<br/>
     * use {@link #setOnErrorListener(IPolyvOnErrorListener2)}
     * @param l
     */
    @Deprecated
    public void setOnErrorListener(IMediaPlayer.OnErrorListener l);
    /**
     * Nothing to do<br/>
     * use {@link #setOnInfoListener(IPolyvOnInfoListener2)}
     * @param l
     */
    @Deprecated
    public void setOnInfoListener(IMediaPlayer.OnInfoListener l);
    /**
     * Nothing to do<br/>
     * use {@link #setOnPreparedListener(IPolyvOnPreparedListener2)}
     * @param l
     */
    @Deprecated
    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener l);
}
