package com.easefun.polyvsdk.video.auxiliary;

import com.easefun.polyvsdk.vo.PolyvVideoVO;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.MediaController.MediaPlayerControl;

/**
 * 辅助视频，用于片头，广告，媒体播放控制接口
 * @version 2.0
 * @author TanQu 2016-10-27
 */
public interface IPolyvAuxiliaryVideoView extends MediaPlayerControl {
	
	/**
	 * 设置数据<br/>
	 * 会重置播放进度
	 * @param polyvVideoVO
	 */
	public void setData(PolyvVideoVO polyvVideoVO);

	/**
	 * 开始或继续播放<br/>
	 * 正片之前播放顺序：片头广告(如果有) -&gt; 片头(如果有)
	 * 正片之后播放顺序: 片尾广告(如果有)
	 */
	public void playNext();
	
	/**
	 * 运行暂停广告
	 */
	public void runPauseAdvert();

	/**
	 * 隐藏
	 */
	public void hide();

	/**
	 * 设置是否开启提醒，最后一个视频广告或者片头倒计时达到指定参数设置的倒计时临界值，就会回调提醒监听方法。
	 * @param isOpenRemind
	 * @param second 秒，参数大于播放时间就取播放时间，小于0就取0
	 */
	public void setOpenRemind(boolean isOpenRemind, int second);
	
	/**
	 * 设置是否开启片头
	 * @param isOpenTeaser
	 */
	public void setOpenTeaser(boolean isOpenTeaser);
	
	/**
	 * 设置是否开启广告
	 * @param isOpenAd
	 */
	public void setOpenAd(boolean isOpenAd);
	
	/**
	 * 设置播放器缓冲视图
	 * @param view
	 */
	public void setPlayerBufferingIndicator(@NonNull View view);

	/**
	 * 释放
	 */
	public void release();

	/**
	 * 销毁
	 */
	public void destroy();
}
