package com.easefun.polyvsdk.video;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * 视频播放失败原因
 * @version 2.0
 * @author Lion 2016-5-23
 */
public class PolyvPlayErrorReason {
	/** 视频异常 */
	//-10000错误
	public static final int VIDEO_ERROR = 20001;
	/** 无法连接网络 */
	public static final int NETWORK_DENIED = 20003;
	/** 流量超标 */
	public static final int OUT_FLOW = 20004;
	/** 账号过期 */
	public static final int TIMEOUT_FLOW = 20005;
	/** 本地视频文件错误 */
	public static final int LOCAL_VIEWO_ERROR = 20007;
	/** 视频开始播放错误 */
	public static final int START_ERROR = 20008;
	/** 没有权限访问视频 */
	public static final int NOT_PERMISSION = 20009;
	/** 没有设置用户token */
	public static final int USER_TOKEN_ERROR = 20010;
	/** 视频状态错误 */
	public static final int VIDEO_STATUS_ERROR = 20011;
	/** 问答json加载错误 see {@link #QUESTION_ERROR}*/
	@Deprecated
	public static final int QUESTION_JSON_ERROR = 20012;
	/** 问答json解析错误 see {@link #QUESTION_ERROR}*/
	@Deprecated
	public static final int QUESTION_JSON_PARSE_ERROR = 20013;
	/** vid错误 */
	public static final int VID_ERROR = 20014;
	/** 码率错误 */
	public static final int BITRATE_ERROR = 20015;
	/** video取得为null */
	public static final int VIDEO_NULL = 20016;
	/** mp4链接数量错误 */
	public static final int MP4_LINK_NUM_ERROR = 20017;
	/** m3u8链接数量错误 */
	public static final int M3U8_LINK_NUM_ERROR = 20018;
	/** 播放视频速度为null */
	public static final int HLS_SPEED_TYPE_NULL = 30001;
	/** 没有缓存视频 */
	public static final int NOT_LOCAL_VIDEO = 30002;
	/** 1.5倍播放地址为空 */
	public static final int HLS_15X_INDEX_EMPTY = 30003;
	/** 1.5倍播放地址错误 */
	public static final int HLS_15X_ERROR = 30004;
	/** 1.5倍播放地址错误 */
	public static final int HLS_15X_URL_ERROR = 30005;
	/** m3u8 15x链接数量错误 */
	public static final int M3U8_15X_LINK_NUM_ERROR = 30006;
	/** 切换码率相同 */
	public static final int CHANGE_EQUAL_BITRATE = 30007;
	/** 切换播放速度相同 */
	public static final int CHANGE_EQUAL_HLS_SPEED = 30008;
	/** 不能切换码率 */
	public static final int CAN_NOT_CHANGE_BITRATE = 30009;
	/** 不能切换速度 */
	public static final int CAN_NOT_CHANGE_HLS_SPEED = 30010;
	/** 视频加载过程中出错 */
	public static final int LOADING_VIDEO_ERROR = 30011;
	/** 问答错误 */
	public static final int QUESTION_ERROR = 30012;
	/** hls url 格式错误 */
	public static final int HLS_URL_ERROR = 30013;
	/** 视频码率不存在 */
	public static final int CHANGE_BITRATE_NOT_EXIST = 30014;
	/** token取得为null */
	public static final int TOKEN_NULL = 30015;
	/**hls2 url 格式错误*/
	public static final int HLS2_URL_ERROR = 30016;
	/** 异常播放完成，比如：在播放过程中，断网，会出现这个错误 */
	public static final int EXCEPTION_COMPLETION = 30017;
	/** 拒绝写入存储设备 */
	public static final int WRITE_EXTERNAL_STORAGE_DENIED = 30018;
	/** 播放地址为空 */
	public static final int SOURCE_URL_EMPTY = 30019;

	/** @hide */
	@IntDef({
			NETWORK_DENIED,
			OUT_FLOW,
			TIMEOUT_FLOW,
			LOCAL_VIEWO_ERROR,
			START_ERROR,
			NOT_PERMISSION,
			USER_TOKEN_ERROR,
			VIDEO_STATUS_ERROR,
			VID_ERROR,
			BITRATE_ERROR,
			VIDEO_NULL,
			MP4_LINK_NUM_ERROR,
			M3U8_LINK_NUM_ERROR,
			HLS_SPEED_TYPE_NULL,
			NOT_LOCAL_VIDEO,
			HLS_15X_INDEX_EMPTY,
			HLS_15X_ERROR,
			HLS_15X_URL_ERROR,
			M3U8_15X_LINK_NUM_ERROR,
			CHANGE_EQUAL_BITRATE,
			CHANGE_EQUAL_HLS_SPEED,
			CAN_NOT_CHANGE_BITRATE,
			CAN_NOT_CHANGE_HLS_SPEED,
			LOADING_VIDEO_ERROR,
			QUESTION_ERROR,
			HLS_URL_ERROR,
			CHANGE_BITRATE_NOT_EXIST,
			TOKEN_NULL,
			HLS2_URL_ERROR,
			EXCEPTION_COMPLETION,
			WRITE_EXTERNAL_STORAGE_DENIED,
			SOURCE_URL_EMPTY
	})
	@Retention(RetentionPolicy.SOURCE)
	public @interface PlayErrorReason {}
}
