package com.easefun.polyvsdk.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;

/**
 * 与屏幕相关的工具类
 * @version 2.0
 * @author TanQu 2017-4-17
 */
public class PolyvScreenTool {
    private static final int HIDE_STATUSBAR = 1;

    private static final Handler HANDLER = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case HIDE_STATUSBAR:
                    reSetStatusBar((Activity) msg.obj);
                    break;
            }
        }
    };

    // 是否横屏
    private static boolean isLandscape(Context context) {
        return context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE;
    }

    /**
     * 设置隐藏状态栏的监听器
     *
     * @param activity
     * @param millissecond
     *            隐藏间隔，毫秒
     */
    public static void setHideStatusBarListener(final Activity activity, final long millissecond) {
        View decorView = activity.getWindow().getDecorView();
        decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener() {

            @Override
            public void onSystemUiVisibilityChange(int visibility) {
                if ((visibility & View.SYSTEM_UI_FLAG_FULLSCREEN) == 0) {
                    Message message = HANDLER.obtainMessage();
                    message.obj = activity;
                    message.what = HIDE_STATUSBAR;
                    HANDLER.sendMessageDelayed(message, millissecond);
                } else {
                }
            }
        });
    }

    /**
     * 获取包含状态栏的屏幕宽度和高度
     *
     * @param activity
     * @return {宽,高}
     */
    public static int[] getNormalWH(Activity activity) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
            DisplayMetrics dm = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
            return new int[] { dm.widthPixels, dm.heightPixels };
        } else {
            Point point = new Point();
            WindowManager wm = activity.getWindowManager();
            wm.getDefaultDisplay().getSize(point);
            return new int[] { point.x, point.y };
        }
    }

    /**
     * 重置状态栏使其在横屏下全屏，在竖屏下显示
     *
     * @param activity
     */
    public static void reSetStatusBar(Activity activity) {
        if (isLandscape(activity)) {
            hideStatusBar(activity);
        } else {
            setDecorVisible(activity);
        }
    }

    // 隐藏状态栏
    private static void hideStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
            activity.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN);
        } else {
            View decorView = activity.getWindow().getDecorView();
            activity.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN);
            int uiOptions = View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_IMMERSIVE | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
            decorView.setSystemUiVisibility(uiOptions);
        }
    }

    // 恢复为不全屏状态
    private static void setDecorVisible(Activity activity) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
            activity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        } else {
            View decorView = activity.getWindow().getDecorView();
            activity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
            int uiOptions = View.SYSTEM_UI_FLAG_VISIBLE;
            decorView.setSystemUiVisibility(uiOptions);
        }
    }
}
