package com.easefun.polyvsdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.List;

/**
 * 改为 {@link com.easefun.polyvsdk.PolyvBitRate}
 * @version 1.0
 * @author TanQu 2015-9-29
 * @see com.easefun.polyvsdk.PolyvBitRate
 */
@Deprecated
public enum BitRateEnum {
    /** 自动 */
    ziDong(PolyvBitRate.ziDong.getNum()) {
        @Override
        public String getName() {
            return PolyvBitRate.ziDongName;
        }
    },
    /** 流畅 */
    liuChang(PolyvBitRate.liuChang.getNum()) {
        @Override
        public String getName() {
            return PolyvBitRate.liuChangName;
        }
    },
    /** 高清 */
    gaoQing(PolyvBitRate.gaoQing.getNum()) {
        @Override
        public String getName() {
            return PolyvBitRate.gaoQingName;
        }
    },
    /** 超清 */
    chaoQing(PolyvBitRate.chaoQing.getNum()) {
        @Override
        public String getName() {
            return PolyvBitRate.chaoQingName;
        }
    };

    private final int num;
    private BitRateEnum(int num) {
        this.num = num;
    }

    /**
     * 取得码率对应的数字
     * @deprecated
     * @return
     */
    public int getNum() {
        return num;
    }

    /**
     * 取得码率对应的名称
     * @deprecated
     * @return
     */
    public abstract String getName();

    /**
     * 取得最低使用的码率(不包括{@code ziDong})
     * @deprecated
     * @return
     */
    public static PolyvBitRate getMinBitRate() {
        return PolyvBitRate.getMinBitRate();
    }

    /**
     * 取得最低使用的码率(包括{@code ziDong})
     * @deprecated
     * @return
     */
    public static PolyvBitRate getMinBitRateFromAll() {
        return PolyvBitRate.getMinBitRateFromAll();
    }

    /**
     * 取得最高使用的码率
     * @deprecated
     * @return
     */
    public static PolyvBitRate getMaxBitRate() {
        return PolyvBitRate.getMaxBitRate();
    }

    /**
     * 根据码率个数取得当中最高可以使用的码率
     * @deprecated
     * @param dfNum 码率个数
     * @return
     */
    public static PolyvBitRate getMaxBitRate(int dfNum) {
        return PolyvBitRate.getMaxBitRate(dfNum);
    }

    /**
     * 根据码率个数取得对应的码率名称数组
     * @deprecated
     * @param dfNum 码率个数
     * @return
     */
    public static String[] getBitRateNameArray(int dfNum) {
        return PolyvBitRate.getBitRateNameArray(dfNum);
    }

    /**
     * 根据码率个数取得对应的码率列表
     * @deprecated
     * @param dfNum 码率个数
     * @return
     */
    public static List<PolyvBitRate> getBitRateList(int dfNum) {
        return PolyvBitRate.getBitRateList(dfNum);
    }

    /**
     * 根据码率取得BitRateEnum 成员
     * @deprecated
     * @param bitRate 码率
     * @return
     */
    @Nullable
    public static PolyvBitRate getBitRate(int bitRate) {
        return PolyvBitRate.getBitRate(bitRate);
    }

    /**
     * 取得码率名称
     * @deprecated
     * @param bitRate 码率
     * @return
     */
    @Nullable
    public static String getBitRateName(int bitRate) {
        return PolyvBitRate.getBitRateName(bitRate);
    }

    /**
     * 取得倒序码率列表
     * @deprecated
     * @return
     */
    @NonNull
    public static List<PolyvBitRate> getDescBitRateList() {
        return PolyvBitRate.getDescBitRateList();
    }

    /**
     * 取得对应的{@link com.easefun.polyvsdk.PolyvBitRate}
     * @param bitrate
     * @return
     */
    @Nullable
    public static PolyvBitRate getPolyvBitRate(@NonNull BitRateEnum bitrate) {
        switch (bitrate) {
            case ziDong:
                return PolyvBitRate.ziDong;
            case liuChang:
                return PolyvBitRate.liuChang;
            case gaoQing:
                return PolyvBitRate.gaoQing;
            case chaoQing:
                return PolyvBitRate.chaoQing;
        }

        return null;
    }
}
