/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.tool;

import android.os.Handler;
import com.eaglexad.lib.http.entry.ExError;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.ible.IExResponseDelivery;
import java.util.concurrent.Executor;

public class ExResponseDelivery
implements IExResponseDelivery {
    private final Executor mResponsePoster;

    public ExResponseDelivery(final Handler handler) {
        this.mResponsePoster = new Executor(){

            @Override
            public void execute(Runnable command) {
                handler.post(command);
            }
        };
    }

    @Override
    public void postResponse(ExRequest request, ExResponse response, boolean isSync) {
        this.postResponse(request, response, isSync, null);
    }

    @Override
    public void postResponse(ExRequest request, ExResponse response, boolean isSync, Runnable runnable) {
        if (request.isCancel) {
            request.finish();
            return;
        }
        if (isSync) {
            if (response.isSuccess) {
                request.callback.onSuccess(response);
            } else {
                ExError exError = ExError.newInstance(response);
                request.callback.onError(exError, exError.responseCode, exError.responseMessage);
            }
            return;
        }
        this.mResponsePoster.execute(new ResponseDeliveryRunnable(request, response, null, runnable));
    }

    @Override
    public void postError(ExRequest request, ExError error, boolean isSync) {
        if (request.isCancel) {
            request.finish();
            return;
        }
        if (isSync) {
            request.callback.onError(error, error.responseCode, error.responseMessage);
            return;
        }
        this.mResponsePoster.execute(new ResponseDeliveryRunnable(request, null, null, null));
    }

    private class ResponseDeliveryRunnable
    implements Runnable {
        private final ExRequest mRequest;
        private final ExResponse mResponse;
        private final ExError mError;
        private final Runnable mRunnable;

        public ResponseDeliveryRunnable(ExRequest request, ExResponse response, ExError error, Runnable runnable) {
            this.mRequest = request;
            this.mResponse = response;
            this.mError = error;
            this.mRunnable = runnable;
        }

        @Override
        public void run() {
            if (this.mRequest.isCancel) {
                this.mRequest.finish();
                return;
            }
            if (this.mResponse != null && this.mResponse.isSuccess && this.mError == null) {
                this.mRequest.callback.onSuccess(this.mResponse);
            } else if (this.mError != null) {
                this.mRequest.callback.onError(this.mError, this.mError.responseCode, this.mError.responseMessage);
            }
            if (this.mRunnable != null) {
                this.mRunnable.run();
            }
        }
    }
}

