/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.tool;

import android.text.TextUtils;
import com.eaglexad.lib.http.entry.ExDownload;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.exception.ErrorConnection;
import com.eaglexad.lib.http.exception.ExHttpException;
import com.eaglexad.lib.http.ible.IExHttpStack;
import com.eaglexad.lib.http.tool.ExHttpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ExHttpStackDownload
implements IExHttpStack {
    private ExRequest mRequest;
    private String mUrl;
    private ExDownload mDownload;
    private Map<String, String> mAdditionalHeaders;
    private HttpURLConnection mConnection;
    private File mFile;
    private InputStream mInputStream;
    private FileOutputStream mOutputStream;

    @Override
    public ExResponse performRequest(ExRequest request, Map<String, String> additionalHeaders) throws ExHttpException {
        this.mRequest = request;
        this.mUrl = request.url;
        this.mDownload = request.getDownload();
        this.mAdditionalHeaders = additionalHeaders;
        ExResponse.Builder builder = new ExResponse.Builder(request.what);
        builder.setReuest(request);
        try {
            this.prepare();
            this.openConnection();
            this.initHeader();
            int responseCode = this.getResponseCode();
            if (responseCode == 200 || responseCode == 206) {
                this.mDownload.totalSize = this.getContentLength();
                this.mInputStream = this.mConnection.getInputStream();
                if (this.mInputStream != null && this.mDownload.totalSize > 0L) {
                    String destFileName;
                    int readSize;
                    this.mOutputStream = new FileOutputStream(this.mFile, responseCode == 206);
                    byte[] buffer = new byte[1024];
                    int progress = (int)(this.mDownload.currSize * 100L / this.mDownload.totalSize);
                    int n = this.mDownload.currProgress = progress > 100 ? 100 : progress;
                    while ((readSize = this.mInputStream.read(buffer)) > 0) {
                        this.mOutputStream.write(buffer, 0, readSize);
                        this.mDownload.currSize += (long)readSize;
                        progress = (int)(this.mDownload.currSize * 100L / this.mDownload.totalSize);
                        if (this.mDownload.currProgress == progress || progress > 100) continue;
                        this.mDownload.currProgress = progress > 100 ? 100 : progress;
                    }
                    if (this.mDownload.currProgress == 100 && this.renameFile(this.mDownload.saveFilePath, destFileName = this.mDownload.saveFilePath.replace(".dl0", this.mDownload.ext))) {
                        this.mDownload.saveFilePath = destFileName;
                    }
                }
            } else if (responseCode == 301 || responseCode == 302) {
                ExResponse buffer = this.performRequest(request, additionalHeaders);
                return buffer;
            }
            builder.setContentLength(this.getContentLength());
            builder.setLastModified(this.getLastModified());
            builder.setExpiration(this.getExpiration());
            builder.setETag(this.getETag());
            builder.setResponseMessage(this.getResponseMessage());
            builder.setResponseCode(responseCode);
            builder.setResponseHeaders(this.getResponseHeaders());
        }
        catch (IOException e) {
            throw new ErrorConnection(e.getMessage(), e);
        }
        finally {
            this.close();
        }
        return builder.builder();
    }

    @Override
    public void close() {
        if (this.mInputStream != null) {
            ExHttpUtils.closeQuietly(this.mInputStream);
        }
        if (this.mOutputStream != null) {
            ExHttpUtils.closeQuietly(this.mOutputStream);
        }
        if (this.mConnection != null) {
            this.mConnection.disconnect();
        }
    }

    private void prepare() throws IOException {
        this.mFile = new File(this.mDownload.saveFilePath);
        if (!this.mFile.exists()) {
            this.mFile.createNewFile();
        } else if (this.mDownload.isOverride) {
            this.mFile.delete();
        }
        this.mDownload.currSize = this.mFile.length();
    }

    private void openConnection() throws IOException {
        URL url = new URL(this.mUrl);
        this.mConnection = (HttpURLConnection)url.openConnection();
        this.mConnection.setReadTimeout(this.mRequest.connectTimeout);
        this.mConnection.setConnectTimeout(this.mRequest.connectTimeout);
        this.mConnection.setRequestProperty("Connection", "Keep-Alive");
        this.mConnection.setRequestProperty("Content-Type", "application/octet-stream");
        this.mConnection.setInstanceFollowRedirects(true);
        if (this.mDownload.currSize > 0L && this.isSupportRange()) {
            this.mConnection.setRequestProperty("RANGE", "bytes=" + this.mDownload.currSize + "-");
        }
    }

    private void initHeader() {
        List<ExRequest.Header> headers = this.mRequest.headers;
        if (headers != null) {
            for (ExRequest.Header header : headers) {
                String name = header.key;
                String value = header.getValueStr();
                if (ExHttpUtils.isEmpty(name) || ExHttpUtils.isEmpty(value)) continue;
                if (header.setHeader) {
                    this.mConnection.setRequestProperty(name, value);
                    continue;
                }
                this.mConnection.addRequestProperty(name, value);
            }
        }
        if (this.mAdditionalHeaders != null && this.mAdditionalHeaders.size() > 0) {
            for (String key : this.mAdditionalHeaders.keySet()) {
                String value = this.mAdditionalHeaders.get(key);
                if (ExHttpUtils.isEmpty(value)) continue;
                this.mConnection.addRequestProperty(key, value);
            }
        }
    }

    private long getContentLength() {
        long result = 0L;
        if (this.mConnection != null) {
            try {
                result = this.mConnection.getContentLength();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (result < 1L) {
                try {
                    result = this.mInputStream.available();
                }
                catch (Throwable throwable) {}
            }
        } else {
            try {
                result = this.mInputStream.available();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private long getExpiration() {
        if (this.mConnection == null) {
            return -1L;
        }
        long expiration = -1L;
        String cacheControl = this.mConnection.getHeaderField("Cache-Control");
        if (!ExHttpUtils.isEmpty(cacheControl)) {
            StringTokenizer tok = new StringTokenizer(cacheControl, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim().toLowerCase();
                if (!token.startsWith("max-age")) continue;
                int eqIdx = token.indexOf(61);
                if (eqIdx <= 0) break;
                try {
                    String value = token.substring(eqIdx + 1).trim();
                    long seconds = Long.parseLong(value);
                    if (seconds <= 0L) break;
                    expiration = System.currentTimeMillis() + seconds * 1000L;
                }
                catch (Throwable throwable) {}
                break;
            }
        }
        if (expiration <= 0L) {
            expiration = this.mConnection.getExpiration();
        }
        if (expiration <= 0L) {
            expiration = System.currentTimeMillis() + (long)this.mRequest.cacheMaxAge;
        }
        if (expiration <= 0L) {
            expiration = Long.MAX_VALUE;
        }
        return expiration;
    }

    private long getLastModified() {
        return this.mConnection == null ? System.currentTimeMillis() : this.mConnection.getHeaderFieldDate("Last-Modified", System.currentTimeMillis());
    }

    private String getETag() {
        return this.mConnection == null ? null : this.mConnection.getHeaderField("ETag");
    }

    private Map<String, List<String>> getResponseHeaders() {
        return this.mConnection == null ? null : this.mConnection.getHeaderFields();
    }

    private int getResponseCode() throws IOException {
        return this.mConnection == null ? -1 : this.mConnection.getResponseCode();
    }

    private String getResponseMessage() throws IOException {
        return this.mConnection == null ? null : URLDecoder.decode(this.mConnection.getResponseMessage(), this.mRequest.charset);
    }

    private String getResponseFileName() {
        int startIndex;
        String disposition = this.mConnection.getHeaderField("Content-Disposition");
        if (!TextUtils.isEmpty((CharSequence)disposition) && (startIndex = disposition.indexOf("filename=")) > 0) {
            int endIndex = disposition.indexOf(";", startIndex += 9);
            if (endIndex < 0) {
                endIndex = disposition.length();
            }
            if (endIndex > startIndex) {
                try {
                    return URLDecoder.decode(disposition.substring(startIndex, endIndex), this.mRequest.charset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private boolean isSupportRange() {
        String ranges = this.mConnection.getHeaderField("Accept-Ranges");
        if (ranges != null) {
            return ranges.contains("bytes");
        }
        ranges = this.mConnection.getHeaderField("Content-Range");
        return ranges != null && ranges.contains("bytes");
    }

    private boolean renameFile(String srcFilePath, String destFilePath) {
        File srcFile = new File(srcFilePath);
        File destFile = new File(destFilePath);
        return srcFile.renameTo(destFile);
    }
}

