/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.tool;

import android.os.Handler;
import android.os.Looper;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.ible.IExNetwork;
import com.eaglexad.lib.http.ible.IExResponseDelivery;
import com.eaglexad.lib.http.tool.ExDispatcherCache;
import com.eaglexad.lib.http.tool.ExDispatcherNetwork;
import com.eaglexad.lib.http.tool.ExHttpUtils;
import com.eaglexad.lib.http.tool.ExResponseDelivery;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ExHttpQueue {
    public static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 4;
    public static final int DEFAULT_NETWORK_THREAD_SINGLE_POOL_SIZE = 1;
    private AtomicInteger mSequenceGenerator = new AtomicInteger();
    private final Set<ExRequest> mCurrentRequests = new HashSet<ExRequest>();
    private final Map<String, Queue<ExRequest>> mWaitingRequests = new HashMap<String, Queue<ExRequest>>();
    private final PriorityBlockingQueue<ExRequest> mCacheQueues = new PriorityBlockingQueue();
    private final PriorityBlockingQueue<ExRequest> mNetWorkQueues = new PriorityBlockingQueue();
    private final IExNetwork mNetWork;
    private final IExResponseDelivery mDelivery;
    private ExDispatcherNetwork[] mDispatcherNetWork;
    private ExDispatcherCache mDispatcherCache;

    public ExHttpQueue(IExNetwork netWork) {
        this(netWork, new ExResponseDelivery(new Handler(Looper.getMainLooper())));
    }

    public ExHttpQueue(IExNetwork netWork, int threadPoolSize) {
        this(netWork, new ExResponseDelivery(new Handler(Looper.getMainLooper())), threadPoolSize);
    }

    public ExHttpQueue(IExNetwork netWork, IExResponseDelivery delivery) {
        this(netWork, delivery, 4);
    }

    public ExHttpQueue(IExNetwork netWork, IExResponseDelivery delivery, int threadPoolSize) {
        this.mNetWork = netWork;
        this.mDelivery = delivery;
        this.mDispatcherNetWork = new ExDispatcherNetwork[threadPoolSize];
    }

    public void start() {
        this.stop();
        this.mDispatcherCache = new ExDispatcherCache(this.mCacheQueues, this.mNetWorkQueues, this.mDelivery);
        this.mDispatcherCache.start();
        int length = this.mDispatcherNetWork.length;
        for (int i = 0; i < length; ++i) {
            ExDispatcherNetwork dispatcherNetwork;
            this.mDispatcherNetWork[i] = dispatcherNetwork = new ExDispatcherNetwork(this.mNetWorkQueues, this.mNetWork, this.mDelivery);
            dispatcherNetwork.start();
        }
    }

    public void stop() {
        if (this.mDispatcherCache != null) {
            this.mDispatcherCache.quit();
        }
        for (ExDispatcherNetwork dispatcherNetwork : this.mDispatcherNetWork) {
            if (dispatcherNetwork == null) continue;
            dispatcherNetwork.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ExRequest request) {
        if (ExHttpUtils.isEmpty(request) || request.isCancel) {
            return;
        }
        request.setQueue(this);
        Object object = this.mCurrentRequests;
        synchronized (object) {
            this.mCurrentRequests.add(request);
        }
        request.setSequence(this.getSequenceNumber());
        if (!request.shouldCache) {
            this.mNetWorkQueues.add(request);
            return;
        }
        object = this.mWaitingRequests;
        synchronized (object) {
            String keyCache = request.getCacheKey();
            if (this.mWaitingRequests.containsKey(keyCache)) {
                Queue<ExRequest> stagedRequests = this.mWaitingRequests.get(keyCache);
                if (stagedRequests == null) {
                    stagedRequests = new LinkedList<ExRequest>();
                }
                stagedRequests.add(request);
                this.mWaitingRequests.put(keyCache, stagedRequests);
                return;
            }
            this.mWaitingRequests.put(keyCache, null);
            this.mCacheQueues.add(request);
        }
    }

    public void execute(ExRequest request) {
        int length;
        if (ExHttpUtils.isEmpty(request) || request.isCancel) {
            return;
        }
        if (request.shouldCache) {
            this.mDispatcherCache.execute(request, true);
        }
        if ((length = this.mDispatcherNetWork.length) > 0) {
            this.mDispatcherNetWork[0].execute(request, true);
        }
    }

    public void cancelAll(final String tag) {
        if (!ExHttpUtils.isEmpty(tag)) {
            this.cancelAll(new RequestFilter(){

                @Override
                public boolean apply(ExRequest request) {
                    return request.tag.equals(tag);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(RequestFilter filter) {
        Set<ExRequest> set = this.mCurrentRequests;
        synchronized (set) {
            for (ExRequest request : this.mCurrentRequests) {
                if (!filter.apply(request)) continue;
                request.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(ExRequest request) {
        Object object = this.mCurrentRequests;
        synchronized (object) {
            this.mCurrentRequests.remove(request);
        }
        if (request.shouldCache) {
            object = this.mWaitingRequests;
            synchronized (object) {
                String keyCache = request.getCacheKey();
                Queue<ExRequest> waitingRequests = this.mWaitingRequests.remove(keyCache);
                if (waitingRequests != null) {
                    this.mCacheQueues.addAll(waitingRequests);
                }
            }
        }
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    public static interface RequestFilter {
        public boolean apply(ExRequest var1);
    }
}

