/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.tool;

import android.os.Process;
import com.eaglexad.lib.http.ExHttp;
import com.eaglexad.lib.http.entry.ExError;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.exception.ErrorNetwork;
import com.eaglexad.lib.http.exception.ExHttpException;
import com.eaglexad.lib.http.ible.IExCache;
import com.eaglexad.lib.http.ible.IExConvert;
import com.eaglexad.lib.http.ible.IExNetwork;
import com.eaglexad.lib.http.ible.IExResponseDelivery;
import com.eaglexad.lib.http.tool.ExHttpUtils;
import java.util.concurrent.BlockingQueue;

public class ExDispatcherNetwork
extends Thread {
    private boolean mQuit;
    private final IExNetwork mNetWork;
    private final BlockingQueue<ExRequest> mNetworkQueue;
    private final IExResponseDelivery mResponseDelivery;

    public ExDispatcherNetwork(BlockingQueue<ExRequest> networkQueue, IExNetwork netWork, IExResponseDelivery delivery) {
        this.mNetWork = netWork;
        this.mNetworkQueue = networkQueue;
        this.mResponseDelivery = delivery;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            try {
                while (true) {
                    ExRequest request = this.mNetworkQueue.take();
                    if (request.isCancel) continue;
                    this.execute(request, false);
                }
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            break;
        }
    }

    public void execute(final ExRequest request, boolean isSync) {
        try {
            if (!ExHttpUtils.isConnected(ExHttp.getContext())) {
                this.useCacheToResponse(request, isSync);
                throw new ErrorNetwork("no network");
            }
            final ExResponse response = this.mNetWork.performRequest(request);
            final IExCache iExCache = request.getCacheIEx();
            IExConvert iExConvert = request.getConvertIEx();
            response.response = !ExHttpUtils.isEmpty(iExConvert) && !ExHttpUtils.isEmpty(request.responseClazz) ? iExConvert.getByte2Cls(response.data, request.responseClazz) : ExHttpUtils.byteToString(response.data, request.charset);
            if (response.isSuccess) {
                if (request.shouldCache && !ExHttpUtils.isEmpty(iExCache)) {
                    this.mResponseDelivery.postResponse(request, response, isSync, new Runnable(){

                        @Override
                        public void run() {
                            if (!ExHttpUtils.isEmpty(iExCache)) {
                                iExCache.put(request.getCacheGroupKey(), request.getCacheKey(), ExHttpUtils.byteToString(response.data, request.charset));
                            }
                        }
                    });
                    return;
                }
                this.mResponseDelivery.postResponse(request, response, isSync);
            } else {
                this.useCacheToResponse(request, isSync);
                this.mResponseDelivery.postError(request, ExError.newInstance(response), isSync);
            }
        }
        catch (ExHttpException http) {
            this.mResponseDelivery.postError(request, ExError.newInstance(http), isSync);
        }
    }

    private void useCacheToResponse(ExRequest request, boolean isSync) {
        IExCache iExCache = request.getCacheIEx();
        IExConvert iExConvert = request.getConvertIEx();
        if (request.shouldCache && !ExHttpUtils.isEmpty(iExCache) && iExCache.contains(request.getCacheKey())) {
            IExCache.Entry entry = iExCache.get(request.getCacheKey());
            if (request.cacheType == ExHttp.CacheType.REQUEST_AFTER && !ExHttpUtils.isEmpty(entry.value)) {
                ExResponse.Builder builder = new ExResponse.Builder(request.what);
                builder.setIsCache();
                builder.setIsSuccess();
                builder.setReuest(request);
                ExResponse responseCache = builder.builder();
                if (!ExHttpUtils.isEmpty(iExConvert) && !ExHttpUtils.isEmpty(request.responseClazz)) {
                    responseCache.response = iExConvert.getString2Cls(entry.value, request.responseClazz);
                }
                if (!ExHttpUtils.isEmpty(responseCache.response)) {
                    this.mResponseDelivery.postResponse(request, responseCache, isSync);
                }
            }
        }
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }
}

