/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.tool;

import android.os.Process;
import com.eaglexad.lib.http.ExHttp;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.ible.IExCache;
import com.eaglexad.lib.http.ible.IExConvert;
import com.eaglexad.lib.http.ible.IExResponseDelivery;
import com.eaglexad.lib.http.tool.ExHttpUtils;
import java.util.concurrent.BlockingQueue;

public class ExDispatcherCache
extends Thread {
    private boolean mQuit;
    private final BlockingQueue<ExRequest> mCacheQueue;
    private final BlockingQueue<ExRequest> mNetworkQueue;
    private final IExResponseDelivery mResponseDelivery;

    public ExDispatcherCache(BlockingQueue<ExRequest> cacheQueue, BlockingQueue<ExRequest> networkQueue, IExResponseDelivery delivery) {
        this.mCacheQueue = cacheQueue;
        this.mNetworkQueue = networkQueue;
        this.mResponseDelivery = delivery;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            try {
                while (true) {
                    ExRequest request = this.mCacheQueue.take();
                    if (request.isCancel) continue;
                    this.execute(request, false);
                    this.mNetworkQueue.put(request);
                }
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            break;
        }
    }

    public void execute(ExRequest request, boolean isSync) {
        IExCache iExCache = request.getCacheIEx();
        IExConvert iExConvert = request.getConvertIEx();
        if (request.shouldCache && !ExHttpUtils.isEmpty(iExCache) && iExCache.contains(request.getCacheKey())) {
            IExCache.Entry entry = iExCache.get(request.getCacheKey());
            if (System.currentTimeMillis() - entry.lastModifiedTime > (long)request.cacheTimeout) {
                iExCache.remove(request.getCacheKey());
            } else if (request.cacheType == ExHttp.CacheType.REQUEST_BEFORE && !ExHttpUtils.isEmpty(entry.value)) {
                ExResponse.Builder builder = new ExResponse.Builder(request.what);
                builder.setIsCache();
                builder.setIsSuccess();
                builder.setReuest(request);
                ExResponse responseCache = builder.builder();
                if (!ExHttpUtils.isEmpty(iExConvert) && !ExHttpUtils.isEmpty(request.responseClazz)) {
                    responseCache.response = iExConvert.getString2Cls(entry.value, request.responseClazz);
                }
                if (!ExHttpUtils.isEmpty(responseCache.response)) {
                    this.mResponseDelivery.postResponse(request, responseCache, isSync);
                }
            }
        }
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }
}

