/*
 * Decompiled with CFR 0.152.
 */
package com.eaglexad.lib.http.body;

import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.ible.IExRequestBody;
import com.eaglexad.lib.http.tool.ExHttpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class ExMultipartBody
implements IExRequestBody {
    private static byte[] BOUNDARY_PREFIX_BYTES = "--------7da3d81520810".getBytes();
    private static byte[] END_BYTES = "\r\n".getBytes();
    private static byte[] TWO_DASHES_BYTES = "--".getBytes();
    private byte[] mBoundaryPostfixBytes;
    private String mContentType;
    private String mCharset = "UTF-8";
    private List<ExRequest.KeyValue> mMultipartParams;
    private long mTotal = 0L;
    private long mCurrent = 0L;

    public ExMultipartBody(List<ExRequest.KeyValue> multipartParams, String charset) {
        if (!ExHttpUtils.isEmpty(charset)) {
            this.mCharset = charset;
        }
        this.mMultipartParams = multipartParams;
        String boundaryPostfix = Double.toHexString(Math.random() * 65535.0);
        this.mBoundaryPostfixBytes = boundaryPostfix.getBytes();
        this.mContentType = "multipart/form-data; boundary=" + new String(BOUNDARY_PREFIX_BYTES) + boundaryPostfix;
    }

    @Override
    public long getContentLength() {
        return this.mTotal;
    }

    @Override
    public void setContentType(String contentType) {
        if (!ExHttpUtils.isEmpty(contentType)) {
            int index = contentType.indexOf(";");
            this.mContentType = "multipart/" + contentType + contentType.substring(index);
        }
    }

    @Override
    public String getContentType() {
        return this.mContentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        for (ExRequest.KeyValue kv : this.mMultipartParams) {
            String name = kv.key;
            Object value = kv.value;
            if (ExHttpUtils.isEmpty(name) || value == null) continue;
            this.writeEntry(out, name, value);
        }
        this.writeLine(out, TWO_DASHES_BYTES, BOUNDARY_PREFIX_BYTES, this.mBoundaryPostfixBytes, TWO_DASHES_BYTES);
        out.flush();
    }

    private void writeEntry(OutputStream out, String name, Object value) throws IOException {
        this.writeLine(out, TWO_DASHES_BYTES, BOUNDARY_PREFIX_BYTES, this.mBoundaryPostfixBytes);
        String fileName = "";
        String contentType = null;
        if (value instanceof File) {
            File file = (File)value;
            if (ExHttpUtils.isEmpty(fileName)) {
                fileName = file.getName();
            }
            contentType = ExHttpUtils.getFileContentType(file);
            this.writeLine(out, new byte[][]{ExMultipartBody.buildContentDisposition(name, fileName, this.mCharset)});
            this.writeLine(out, new byte[][]{ExMultipartBody.buildContentType(value, contentType, this.mCharset)});
            this.writeLine(out, new byte[0][]);
            this.writeFile(out, file);
            this.writeLine(out, new byte[0][]);
        } else {
            this.writeLine(out, new byte[][]{ExMultipartBody.buildContentDisposition(name, fileName, this.mCharset)});
            this.writeLine(out, new byte[][]{ExMultipartBody.buildContentType(value, contentType, this.mCharset)});
            this.writeLine(out, new byte[0][]);
            if (value instanceof InputStream) {
                this.writeStreamAndCloseIn(out, (InputStream)value);
                this.writeLine(out, new byte[0][]);
            } else {
                byte[] content = value instanceof byte[] ? (byte[])value : String.valueOf(value).getBytes(this.mCharset);
                this.writeLine(out, new byte[][]{content});
                this.mCurrent += (long)content.length;
            }
        }
    }

    private void writeLine(OutputStream out, byte[] ... bs) throws IOException {
        if (bs != null) {
            for (byte[] b : bs) {
                out.write(b);
            }
        }
        out.write(END_BYTES);
    }

    private void writeFile(OutputStream out, File file) throws IOException {
        if (out instanceof CounterOutputStream) {
            ((CounterOutputStream)out).addFile(file);
        } else {
            this.writeStreamAndCloseIn(out, new FileInputStream(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamAndCloseIn(OutputStream out, InputStream in) throws IOException {
        if (out instanceof CounterOutputStream) {
            ((CounterOutputStream)out).addStream(in);
        } else {
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                    this.mCurrent += (long)len;
                }
            }
            finally {
                ExHttpUtils.closeQuietly(in);
            }
        }
    }

    private static byte[] buildContentDisposition(String name, String fileName, String charset) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder("Content-Disposition: form-data");
        result.append("; name=\"");
        result.append(name.replace("\"", "\\\""));
        result.append("\"");
        if (!ExHttpUtils.isEmpty(fileName)) {
            result.append("; filename=\"");
            result.append(fileName.replace("\"", "\\\""));
            result.append("\"");
        }
        return result.toString().getBytes(charset);
    }

    private static byte[] buildContentType(Object value, String contentType, String charset) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder("Content-Type: ");
        contentType = ExHttpUtils.isEmpty(contentType) ? (value instanceof String ? "text/plain; charset:" + charset : "application/octet-stream") : contentType.replaceFirst("\\/jpg$", "/jpeg");
        result.append(contentType);
        return result.toString().getBytes(charset);
    }

    private class CounterOutputStream
    extends OutputStream {
        final AtomicLong total = new AtomicLong(0L);

        public void addFile(File file) {
            if (this.total.get() == -1L) {
                return;
            }
            this.total.addAndGet(file.length());
        }

        public void addStream(InputStream inputStream) {
            if (this.total.get() == -1L) {
                return;
            }
            long length = ExHttpUtils.getInputStreamLength(inputStream);
            if (length > 0L) {
                this.total.addAndGet(length);
            } else {
                this.total.set(-1L);
            }
        }

        @Override
        public void write(int oneByte) throws IOException {
            if (this.total.get() == -1L) {
                return;
            }
            this.total.incrementAndGet();
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            if (this.total.get() == -1L) {
                return;
            }
            this.total.addAndGet(buffer.length);
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            if (this.total.get() == -1L) {
                return;
            }
            this.total.addAndGet(count);
        }
    }
}

