/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.tool;

import android.os.Handler;

import com.eaglexad.lib.http.entry.ExError;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.ible.IExResponseDelivery;

import java.util.concurrent.Executor;

/**
 * @author Aloneter
 * @ClassName: ExResponseDelivery
 * @Description:
 */
public class ExResponseDelivery implements IExResponseDelivery {

    private final Executor mResponsePoster;

    public ExResponseDelivery(final Handler handler) {

        mResponsePoster = new Executor() {
            @Override
            public void execute(Runnable command) {
                handler.post(command);
            }
        };
    }

    @Override
    public void postResponse(ExRequest request, ExResponse response, boolean isSync) {

        postResponse(request, response, isSync, null);
    }

    @Override
    public void postResponse(ExRequest request, ExResponse response, boolean isSync, Runnable runnable) {

        if (request.isCancel) {
            request.finish();

            return;
        }
        if (isSync) {
            if (response.isSuccess) {
                request.callback.onSuccess(response);
            } else {
                ExError exError = ExError.newInstance(response);

                request.callback.onError(exError, exError.responseCode, exError.responseMessage);
            }

            return;
        }

        mResponsePoster.execute(new ResponseDeliveryRunnable(request, response, null, runnable));
    }

    @Override
    public void postError(ExRequest request, ExError error, boolean isSync) {

        if (request.isCancel) {
            request.finish();

            return;
        }
        if (isSync) {
            request.callback.onError(error, error.responseCode, error.responseMessage);

            return;
        }

        mResponsePoster.execute(new ResponseDeliveryRunnable(request, null, null, null));
    }

    private class ResponseDeliveryRunnable implements Runnable {

        private final ExRequest mRequest;
        private final ExResponse mResponse;
        private final ExError mError;
        private final Runnable mRunnable;

        public ResponseDeliveryRunnable(ExRequest request, ExResponse response, ExError error, Runnable runnable) {

            mRequest = request;
            mResponse = response;
            mError = error;
            mRunnable = runnable;
        }

        @Override
        public void run() {

            if (mRequest.isCancel) {
                mRequest.finish();

                return;
            }
            if (mResponse != null && mResponse.isSuccess && mError == null) {
                mRequest.callback.onSuccess(mResponse);
            } else {
                if (mError != null) {
                    mRequest.callback.onError(mError, mError.responseCode, mError.responseMessage);
                }
            }
            if (mRunnable != null) {
                mRunnable.run();
            }
        }
    }

}
