/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.body;

import com.eaglexad.lib.http.ible.IExRequestBody;
import com.eaglexad.lib.http.tool.ExHttpUtils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author Aloneter
 * @ClassName: ExInputStreamBody
 * @Description:
 */
public class ExInputStreamBody implements IExRequestBody {

    private InputStream mContent;
    private String mContentType;

    private final long mTotal;
    private long mCurrent = 0;

    public ExInputStreamBody(InputStream inputStream) {
        this(inputStream, null);
    }

    public ExInputStreamBody(InputStream inputStream, String contentType) {
        mContent = inputStream;
        mContentType = contentType;
        mTotal = ExHttpUtils.getInputStreamLength(inputStream);
    }

    @Override
    public long getContentLength() {

        return mTotal;
    }

    @Override
    public void setContentType(String contentType) {

        if (!ExHttpUtils.isEmpty(contentType)) {
            mContentType = contentType;
        }
    }

    @Override
    public String getContentType() {

        if (!ExHttpUtils.isEmpty(mContentType)) {
            mContentType = "application/octet-stream";
        }

        return mContentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {

        byte[] buffer = new byte[1024];

        try {
            int len = 0;
            while ((len = mContent.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                mCurrent += len;
            }
            out.flush();

        } finally {
            ExHttpUtils.closeQuietly(mContent);
        }
    }

}
