/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import com.eaglesakura.lambda.Action1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Util {
    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    public static double getDouble(Double value, double defValue) {
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public static float getFloat(Float value, float defValue) {
        if (value == null) {
            return defValue;
        }
        return value.floatValue();
    }

    public static long getLong(Long value, long defValue) {
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public static int getInt(Integer value, int defValue) {
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public static short getShort(Short value, short defValue) {
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public static byte getByte(Byte value, byte defValue) {
        if (value == null) {
            return defValue;
        }
        return value;
    }

    @Deprecated
    public static Date getDateStart(Date date) {
        long oneDay = 86400000L;
        long now = date.getTime();
        return new Date(now / oneDay * oneDay);
    }

    @Deprecated
    public static Date getDateEnd(Date date) {
        return new Date(Util.getDateStart(date).getTime() + 86400000L - 1L);
    }

    @Deprecated
    public static Date getTodayStart() {
        long oneDay = 86400000L;
        long now = System.currentTimeMillis();
        return new Date(now / 86400000L * 86400000L);
    }

    @Deprecated
    public static Date getTodayEnd() {
        return new Date(Util.getTodayStart().getTime() + 86400000L - 1L);
    }

    public static void sleep(long timems) {
        if (timems <= 0L) {
            return;
        }
        try {
            Thread.sleep(timems);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void nanosleep(long ms, int nano) {
        if (ms <= 0L && nano <= 0) {
            return;
        }
        try {
            Thread.sleep(ms, nano);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T ifPresent(T value, Action1<T> action) {
        if (value != null) {
            try {
                action.action(value);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    public static <T> T safeIfPresent(T value, Action1<T> action) {
        if (value != null) {
            try {
                action.action(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return value;
    }

    @Deprecated
    public static <T> boolean addUnique(List<T> list, T item) {
        if (!list.contains(item)) {
            list.add(item);
            return true;
        }
        return false;
    }

    @Deprecated
    public static <T> int addUniqueRequestIndex(List<T> list, T item) {
        Util.addUnique(list, item);
        return list.indexOf(item);
    }

    @Deprecated
    public static <T> T[] convert(Collection<T> c, T[] array) {
        return c.toArray(array);
    }

    @Deprecated
    public static <T> List<T> convert(T[] array) {
        return new ArrayList<T>(Arrays.asList(array));
    }

    @Deprecated
    public static <T> T[] copy(T[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static <Key, Value> Map<Key, Value> asMap(Collection<Value> values, KeyCreator<Key, Value> keyCreator) {
        HashMap<Key, Value> result = new HashMap<Key, Value>();
        for (Value value : values) {
            result.put(keyCreator.createKey(value), value);
        }
        return result;
    }

    @Deprecated
    public static boolean isEmpty(byte[] item) {
        return item == null || item.length == 0;
    }

    @Deprecated
    public static <T> boolean isEmpty(T[] item) {
        return item == null || item.length == 0;
    }

    @Deprecated
    public static <T> boolean isEmpty(List<T> item) {
        return item == null || item.isEmpty();
    }

    @Deprecated
    public static <T> T newInstanceOrNull(String className) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public static <T> T newInstanceOrNull(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public static <T, R> List<R> convert(List<T> origin, ItemConverter<T, R> converter) {
        if (Util.isEmpty(origin)) {
            return Collections.emptyList();
        }
        ArrayList<R> result = new ArrayList<R>(origin.size());
        for (T item : origin) {
            result.add(converter.as(item));
        }
        return result;
    }

    @Deprecated
    public static interface ItemConverter<T, R> {
        public R as(T var1);
    }

    @Deprecated
    public static interface KeyCreator<Key, Value> {
        public Key createKey(Value var1);
    }
}

