/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

public class Timer {
    protected long startTime = System.currentTimeMillis();
    protected long endTime = System.currentTimeMillis();

    public Timer() {
    }

    public Timer(long startTime) {
        this.startTime = startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void start() {
        this.endTime = this.startTime = System.currentTimeMillis();
    }

    public long end() {
        this.endTime = System.currentTimeMillis();
        return this.endTime - this.startTime;
    }

    public double endSec() {
        return Timer.msToSec(this.end());
    }

    public double endMinute() {
        return Timer.msToMinute(this.end());
    }

    public double endHour() {
        return Timer.msToHour(this.end());
    }

    public double endDay() {
        return Timer.msToDay(this.end());
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isEnd() {
        return this.endTime != this.startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public static long toMilliSec(int day, int hour, int minute, int sec, int millisec) {
        return 86400000L * (long)day + 3600000L * (long)hour + 60000L * (long)minute + 1000L * (long)sec + (long)millisec;
    }

    public static double msToSec(long milliSec) {
        return (double)milliSec / 1000.0;
    }

    public static double msToMinute(long milliSec) {
        return (double)milliSec / 60000.0;
    }

    public static double msToHour(long milliSec) {
        return (double)milliSec / 3600000.0;
    }

    public static double msToDay(long milliSec) {
        return (double)milliSec / 8.64E7;
    }
}

