/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import com.eaglesakura.util.ThrowableRunnable;
import com.eaglesakura.util.Util;

public class ThrowableRunner<ResultType, ErrorType extends Throwable>
implements Runnable {
    private ErrorType mError;
    private ResultType mResult;
    private ThrowableRunnable<ResultType, ErrorType> mRunner;

    public ThrowableRunner(ThrowableRunnable<ResultType, ErrorType> runner) {
        this.mRunner = runner;
    }

    @Override
    public final void run() {
        try {
            this.mResult = this.mRunner.run();
        }
        catch (Throwable e) {
            this.mError = e;
        }
    }

    public ResultType await() throws ErrorType {
        while (this.mResult == null) {
            if (this.mError != null) {
                throw this.mError;
            }
            Util.sleep(1L);
        }
        return this.mResult;
    }

    public ResultType getOrThrow() throws ErrorType {
        if (this.mError != null) {
            throw this.mError;
        }
        return this.mResult;
    }
}

