/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import com.eaglesakura.util.EncodeUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class StringUtil {
    private static final Locale sLocale = Locale.getDefault();
    private static final SimpleDateFormat DEFAULT_FORMATTER;
    private static final SimpleDateFormat EXIF_FORMATTER;
    private static Base64Converter base64Converter;

    public static boolean allEmpty(String ... args) {
        for (String arg : args) {
            if (StringUtil.isEmpty(arg)) continue;
            return false;
        }
        return true;
    }

    public static boolean allNotEmpty(String ... args) {
        for (String arg : args) {
            if (!StringUtil.isEmpty(arg)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.length() == 0;
    }

    public static String emptyToNull(String str) {
        return StringUtil.isEmpty(str) ? null : str;
    }

    public static String trimSpacesOrEmpty(String src) {
        if (src == null) {
            return "";
        }
        while (src.startsWith(" ")) {
            src = src.substring(1);
        }
        while (src.endsWith(" ")) {
            src = src.substring(0, src.length() - 1);
        }
        while (src.startsWith("\u3000")) {
            src = src.substring(1);
        }
        while (src.endsWith("\u3000")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    public static String zenkakuEngToHankakuEng(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c >= '\uff21' && c <= '\uff3a') {
                c = (char)(c - 65313 + 65);
            } else if (c >= '\uff10' && c <= '\uff19') {
                c = (char)(c - 65296 + 48);
            } else {
                switch (c) {
                    case '\uff1c': {
                        c = '<';
                        break;
                    }
                    case '\uff1e': {
                        c = '>';
                        break;
                    }
                    case '\u3000': {
                        c = ' ';
                        break;
                    }
                    case '\uff0f': {
                        c = '/';
                        break;
                    }
                    case '\uff01': {
                        c = '!';
                        break;
                    }
                    case '\uff1f': {
                        c = '?';
                        break;
                    }
                    case '\uff0e': {
                        c = '.';
                    }
                }
            }
            sb.setCharAt(i, c);
        }
        return sb.toString();
    }

    public static String zenkakuHiraganaToZenkakuKatakana(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c >= '\u30a1' && c <= '\u30f3') {
                sb.setCharAt(i, (char)(c - 12449 + 12353));
                continue;
            }
            if (c == '\u30f5') {
                sb.setCharAt(i, '\u304b');
                continue;
            }
            if (c == '\u30f6') {
                sb.setCharAt(i, '\u3051');
                continue;
            }
            if (c != '\u30f4') continue;
            sb.setCharAt(i, '\u3046');
            sb.insert(i + 1, '\u309b');
            ++i;
        }
        return sb.toString();
    }

    public static String macStringToWinString(String str) {
        boolean indexOffsetDakuten = true;
        int indexOffsetHandakuten = 2;
        int dakuten = 12441;
        int handakuten = 12442;
        StringBuffer sb = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (i < str.length() - 1) {
                char cNext = str.charAt(i + 1);
                if (cNext == '\u3099') {
                    switch (c) {
                        case 12358: {
                            c = 12436;
                            break;
                        }
                        case 12454: {
                            c = 12532;
                            break;
                        }
                        default: {
                            c = (char)(c + 1);
                            break;
                        }
                    }
                } else if (cNext == '\u309a') {
                    c = (char)(c + 2);
                }
            }
            if (c == 12441 || c == 12442) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static int compareString(String a, String b) {
        a = StringUtil.zenkakuHiraganaToZenkakuKatakana(a.toLowerCase());
        a = StringUtil.zenkakuEngToHankakuEng(a);
        b = StringUtil.zenkakuHiraganaToZenkakuKatakana(b.toLowerCase());
        b = StringUtil.zenkakuEngToHankakuEng(b);
        return a.compareTo(b);
    }

    public static String toString(Date date) {
        return DEFAULT_FORMATTER.format(date);
    }

    public static Date toDate(String date) {
        try {
            return DEFAULT_FORMATTER.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date toExifDate(String exifDate) {
        try {
            return EXIF_FORMATTER.parse(exifDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int toInteger(String value, int def) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static double toDouble(String value, double def) {
        try {
            return Double.valueOf(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static boolean toBoolean(String value, boolean def) {
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static String toString(byte[] buffer) {
        return base64Converter.encode(buffer);
    }

    public static byte[] toByteArray(String base64) {
        return base64Converter.decode(base64);
    }

    public static String toHexString(byte b) {
        String result = Integer.toHexString(b & 0xFF);
        if (result.length() == 1) {
            return "0" + result;
        }
        return result;
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer sBuffer = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() == 1) {
                sBuffer.append('0');
            }
            sBuffer.append(s);
        }
        return sBuffer.toString();
    }

    public static long parseHex(String intHex, long defValue) {
        if (StringUtil.isEmpty(intHex)) {
            return defValue;
        }
        if ((intHex = intHex.toUpperCase()).startsWith("0X")) {
            intHex = intHex.substring(2);
        } else if (intHex.startsWith("#")) {
            intHex = intHex.substring(1);
        }
        try {
            return Long.parseLong(intHex, 16);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static int parseWebColorRGB2XRGB(String webColor) {
        int rgb = (int)(StringUtil.parseHex(webColor, -1L) & 0xFFFFFFL);
        return 0xFF000000 | rgb;
    }

    public static int parseWebColorARGB2ARGB(String webColor) {
        int argb = (int)(StringUtil.parseHex(webColor, -1L) & 0xFFFFFFFFL);
        return argb;
    }

    public static String format(String fmt, Object ... args) {
        return String.format(sLocale, fmt, args);
    }

    public static long getHash64(String str) {
        return EncodeUtil.getHash64(str.getBytes(), 1311768467463786514L);
    }

    public static String replaceAllSimple(String value, String org, String rep) {
        String result = value;
        while (result.contains(org)) {
            result = value.replace(org, rep);
        }
        return result;
    }

    public static String toDisplayText(BigDecimal decimal) {
        String value = decimal.abs().toString();
        String[] nums = value.split("\\.");
        String integerOrigin = nums[0];
        String result = "";
        int count = 0;
        for (int i = integerOrigin.length() - 1; i >= 0; --i) {
            if (count > 0 && count % 3 == 0) {
                result = "," + result;
            }
            char it = integerOrigin.charAt(i);
            result = it + result;
            ++count;
        }
        if (nums.length == 2) {
            result = result + "." + nums[1];
        }
        if (decimal.compareTo(BigDecimal.ZERO) < 0) {
            result = "-" + result;
        }
        return result;
    }

    static {
        base64Converter = new Base64Converter(){
            private Object mBase64EncoderObj = null;
            private Object mBase64DecoderObj = null;
            private Method base64Encode = null;
            private Method base64Decode = null;
            private int flags;
            static final int ANDROID_URL_SAFE = 8;
            static final int ANDROID_NO_WRAP = 2;
            static final int ANDROID_NO_PADDING = 1;
            static final int ANDROID_NO_CLOSE = 16;

            Base64Converter init() {
                try {
                    this.mBase64EncoderObj = Class.forName("android.util.Base64");
                    this.mBase64DecoderObj = this.mBase64EncoderObj;
                    this.base64Encode = ((Class)this.mBase64EncoderObj).getMethod("encodeToString", byte[].class, Integer.TYPE);
                    this.base64Decode = ((Class)this.mBase64EncoderObj).getMethod("decode", String.class, Integer.TYPE);
                    this.flags = 27;
                    return this;
                }
                catch (Exception exception) {
                    try {
                        this.mBase64EncoderObj = Class.forName("org.apache.commons.codec.binary.Base64");
                        this.mBase64DecoderObj = this.mBase64EncoderObj;
                        this.base64Encode = ((Class)this.mBase64EncoderObj).getMethod("encodeBase64String", byte[].class);
                        this.base64Decode = ((Class)this.mBase64EncoderObj).getMethod("decodeBase64", String.class);
                        return this;
                    }
                    catch (Exception exception2) {
                        try {
                            Class<?> Base64 = Class.forName("java.util.Base64");
                            Method getEncoder = Base64.getMethod("getEncoder", new Class[0]);
                            this.mBase64EncoderObj = getEncoder.invoke(Base64, new Object[0]);
                            this.base64Encode = this.mBase64EncoderObj.getClass().getMethod("encodeToString", byte[].class);
                            Method getDecoder = Base64.getMethod("getDecoder", new Class[0]);
                            this.mBase64DecoderObj = getDecoder.invoke(Base64, new Object[0]);
                            this.base64Decode = this.mBase64DecoderObj.getClass().getMethod("decode", String.class);
                            return this;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            }

            @Override
            public String encode(byte[] buffer) {
                try {
                    if (this.flags != 0) {
                        return (String)this.base64Encode.invoke(this.mBase64EncoderObj, buffer, this.flags);
                    }
                    return (String)this.base64Encode.invoke(this.mBase64EncoderObj, new Object[]{buffer});
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public byte[] decode(String base64) {
                try {
                    if (this.flags != 0) {
                        return (byte[])this.base64Decode.invoke(this.mBase64DecoderObj, base64, this.flags);
                    }
                    return (byte[])this.base64Decode.invoke(this.mBase64DecoderObj, base64);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }.init();
        DEFAULT_FORMATTER = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SS");
        EXIF_FORMATTER = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    }

    public static interface Base64Converter {
        public String encode(byte[] var1);

        public byte[] decode(String var1);
    }
}

