/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReflectionUtil {
    public static <T extends Annotation> List<Field> listAnnotationFields(Class srcClass, Class<T> annotationClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (!srcClass.equals(Object.class)) {
            for (Field field : srcClass.getDeclaredFields()) {
                T annotation = field.getAnnotation(annotationClass);
                if (annotation == null) continue;
                result.add(field);
            }
            srcClass = srcClass.getSuperclass();
        }
        return result;
    }

    public static <T extends Annotation> List<Method> listAnnotationMethods(Class srcClass, Class<T> annotationClass) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        while (!srcClass.equals(Object.class)) {
            for (Method method : srcClass.getDeclaredMethods()) {
                T annotation = method.getAnnotation(annotationClass);
                if (annotation == null || result.containsKey(method.getName())) continue;
                result.put(method.getName(), method);
            }
            srcClass = srcClass.getSuperclass();
        }
        return new ArrayList<Method>(result.values());
    }

    public static <T extends Enum> T valueOf(Class<T> clazz, String name) {
        try {
            Method valueOfMethod = clazz.getMethod("valueOf", String.class);
            return (T)((Enum)valueOfMethod.invoke(clazz, name));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends Enum> T valueOf(Class<T> clazz, String name, T defValue) {
        T result = ReflectionUtil.valueOf(clazz, name);
        if (result == null) {
            return defValue;
        }
        return result;
    }

    public static boolean instanceOf(Object obj, Class<?> clazz) {
        if (obj == null || clazz == null) {
            return false;
        }
        try {
            return obj.getClass().asSubclass(clazz) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isListInterface(Class<?> clazz) {
        try {
            return clazz.asSubclass(List.class) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Class getListGenericClass(Field field) {
        if (!ReflectionUtil.isListInterface(field)) {
            throw new IllegalArgumentException();
        }
        try {
            Type genericType = field.getGenericType();
            return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isListInterface(Field field) {
        return ReflectionUtil.isListInterface(field.getType());
    }

    public static <T> Constructor<T> getConstructorOrNull(Class<T> clazz, Class ... args) {
        try {
            return clazz.getConstructor(args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T newInstanceOrNull(Constructor<T> constructor, Object ... args) {
        if (constructor == null) {
            return null;
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T newInstanceOrNull(String className) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T newInstanceOrNull(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

