/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import com.eaglesakura.util.CollectionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class RandomUtil {
    public static boolean randBool() {
        return RandomUtil.randInt8() % 2 == 0;
    }

    public static byte randInt8() {
        return (byte)(Math.random() * 255.0 - 128.0);
    }

    public static short randInt16() {
        return (short)(Math.random() * 65535.0);
    }

    public static int randInt32() {
        return (int)(Math.random() * 4.294967295E9);
    }

    public static long randInt64() {
        return ((long)RandomUtil.randInt32() & 0xFFFFFFFFL) << 32 | (long)RandomUtil.randInt32() & 0xFFFFFFFFL;
    }

    public static byte randUInt8() {
        return (byte)(Math.random() * 127.0);
    }

    public static short randUInt16() {
        return (short)(RandomUtil.randInt16() & Short.MAX_VALUE);
    }

    public static int randUInt32() {
        return RandomUtil.randInt32() & Integer.MAX_VALUE;
    }

    public static long randUInt64() {
        return RandomUtil.randInt64() & Long.MAX_VALUE;
    }

    public static float randFloat() {
        return (float)Math.random();
    }

    public static byte randNumAlphabet() {
        switch (RandomUtil.randUInt8() % 5) {
            case 0: 
            case 1: {
                return (byte)(97 + RandomUtil.randUInt8() % 26);
            }
            case 2: 
            case 3: {
                return (byte)(65 + RandomUtil.randUInt8() % 26);
            }
        }
        return (byte)(48 + RandomUtil.randUInt8() % 10);
    }

    public static String randString(int length) {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = RandomUtil.randNumAlphabet();
        }
        return new String(buffer);
    }

    public static String randShortString() {
        return RandomUtil.randString(6) + (RandomUtil.randUInt16() & 0xFF);
    }

    public static String randString() {
        return RandomUtil.randString(32);
    }

    public static String randLargeString() {
        return RandomUtil.randString(1024);
    }

    public static byte[] randBytes() {
        return RandomUtil.randBytes(32 + RandomUtil.randUInt8());
    }

    public static byte[] randBytes(int length) {
        byte[] buffer = new byte[length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = RandomUtil.randInt8();
        }
        return buffer;
    }

    public static <T extends Enum> T randEnum(Class<T> clazz) {
        try {
            Method valuesMethod = clazz.getMethod("values", new Class[0]);
            Enum[] values = (Enum[])valuesMethod.invoke(clazz, new Object[0]);
            return (T)values[RandomUtil.randUInt8() % values.length];
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends Enum> T randEnumWithNull(Class<T> clazz) {
        try {
            Method valuesMethod = clazz.getMethod("values", new Class[0]);
            Enum[] values = (Enum[])valuesMethod.invoke(clazz, new Object[0]);
            if (RandomUtil.randUInt8() % (values.length + 1) == 0) {
                return null;
            }
            return (T)values[RandomUtil.randUInt8() % values.length];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T randGet(Collection<T> items) {
        if (CollectionUtil.isEmpty(items)) {
            throw new IllegalArgumentException();
        }
        ArrayList<T> temp = new ArrayList<T>(items);
        return (T)temp.get(RandomUtil.randUInt32() % items.size());
    }
}

