/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

public class MathUtil {
    public static final int setFlag(int flg, int check, boolean is) {
        if (is) {
            return flg | check;
        }
        return flg & ~check;
    }

    public static final int minmax(int min, int max, int now) {
        if (now < min) {
            return min;
        }
        if (now > max) {
            return max;
        }
        return now;
    }

    public static final float minmax(float min, float max, float now) {
        if (now < min) {
            return min;
        }
        if (now > max) {
            return max;
        }
        return now;
    }

    public static final double minmax(double min, double max, double now) {
        if (now < min) {
            return min;
        }
        if (now > max) {
            return max;
        }
        return now;
    }

    public static final float normalizeDegree(float now) {
        while (now < 0.0f) {
            now += 360.0f;
        }
        while (now >= 360.0f) {
            now -= 360.0f;
        }
        return now;
    }

    public static final double normalizeDegree(double now) {
        while (now < 0.0) {
            now += 360.0;
        }
        while (now >= 360.0) {
            now -= 360.0;
        }
        return now;
    }

    public static final double calcNearDegree(double now, double target) {
        now = MathUtil.normalizeDegree(now);
        double diff = (target = MathUtil.normalizeDegree(target)) - now;
        if (Math.abs(diff) <= 180.0) {
            return target;
        }
        if (now > 180.0) {
            return target + 360.0;
        }
        return target - 360.0;
    }

    public static final double targetMove(double now, double offset, double target) {
        offset = Math.abs(offset);
        if (Math.abs(target - now) <= offset) {
            return target;
        }
        if (target > now) {
            return now + offset;
        }
        return now - offset;
    }

    public static final float targetMove(float now, float offset, float target) {
        offset = Math.abs(offset);
        if (Math.abs(target - now) <= offset) {
            return target;
        }
        if (target > now) {
            return now + offset;
        }
        return now - offset;
    }

    public static final int targetMove(int now, int offset, int target) {
        offset = Math.abs(offset);
        if (Math.abs(target - now) <= offset) {
            return target;
        }
        if (target > now) {
            return now + offset;
        }
        return now - offset;
    }

    public static float blendValue(float a, float b, float blend) {
        return a * blend + b * (1.0f - blend);
    }

    public static double blendValue(double a, double b, double blend) {
        return a * blend + b * (1.0 - blend);
    }

    public static final boolean isFlagOn(int flg, int check) {
        return (flg & check) != 0;
    }

    public static final boolean isFlagOnAll(int flg, int check) {
        return (flg & check) == 0;
    }

    public static final double valueOf(String format, String value) {
        double temp = Double.valueOf(value);
        return Double.valueOf(String.format(format, temp));
    }
}

