/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import com.eaglesakura.io.Disposable;
import com.eaglesakura.lambda.Action1;
import com.eaglesakura.util.CollectionUtil;
import com.eaglesakura.util.EncodeUtil;
import com.eaglesakura.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IOUtil {
    public static void textStreamLines(InputStream is, Action1<String> action) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while (!StringUtil.isEmpty(line = reader.readLine())) {
            try {
                action.action(line);
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
    }

    public static void copyTo(InputStream input, OutputStream output) throws IOException {
        IOUtil.copyTo(input, true, output, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTo(InputStream input, boolean closeInput, OutputStream output, boolean closeOutput) throws IOException {
        try {
            int length;
            byte[] buffer = new byte[131072];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        finally {
            if (closeInput) {
                IOUtil.close(input);
            }
            if (closeOutput) {
                IOUtil.close(output);
            }
        }
    }

    public static final byte[] toByteArray(int[] array) {
        byte[] result = new byte[array.length * 4];
        return IOUtil.toByteArray(array, result);
    }

    public static final byte[] toByteArray(int[] array, byte[] result) {
        for (int i = 0; i < array.length; ++i) {
            result[i * 4 + 0] = (byte)(array[i] >> 24 & 0xFF);
            result[i * 4 + 1] = (byte)(array[i] >> 16 & 0xFF);
            result[i * 4 + 2] = (byte)(array[i] >> 8 & 0xFF);
            result[i * 4 + 3] = (byte)(array[i] >> 0 & 0xFF);
        }
        return result;
    }

    public static String toString(InputStream is, boolean close) throws IOException {
        byte[] buffer = IOUtil.toByteArray(is, close);
        return new String(buffer);
    }

    public static byte[] toByteArrayOrNull(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            return IOUtil.toByteArray(is, true);
        }
        catch (Exception e) {
            IOUtil.close(is);
            return null;
        }
    }

    public static String toStringOrNull(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            return IOUtil.toString(is, true);
        }
        catch (Exception e) {
            IOUtil.close(is);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream is, boolean close) throws IOException {
        byte[] result = null;
        byte[] tempBuffer = new byte[4096];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int n = 0;
            while ((n = is.read(tempBuffer)) > 0) {
                baos.write(tempBuffer, 0, n);
            }
            result = baos.toByteArray();
        }
        finally {
            if (close) {
                IOUtil.close(is);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(File src, File dst) throws IOException {
        IOUtil.mkdirs(dst.getParentFile());
        FileInputStream srcStream = null;
        FileOutputStream dstStream = null;
        try {
            srcStream = new FileInputStream(src);
            dstStream = new FileOutputStream(dst);
            byte[] buffer = new byte[131072];
            int readed = 0;
            while ((readed = ((InputStream)srcStream).read(buffer)) > 0) {
                ((OutputStream)dstStream).write(buffer, 0, readed);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(srcStream);
            IOUtil.close(dstStream);
            throw throwable;
        }
        IOUtil.close(srcStream);
        IOUtil.close(dstStream);
        dst.setLastModified(src.lastModified());
    }

    public static final void copyOrUpdate(File src, File dst) throws IOException {
        String dstSHA1;
        if (!dst.isFile()) {
            IOUtil.copy(src, dst);
            return;
        }
        String srcSHA1 = IOUtil.genSHA1(src);
        if (!srcSHA1.equals(dstSHA1 = IOUtil.genSHA1(dst))) {
            IOUtil.copy(src, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genMD5(File file) {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[131072];
            int readed = 0;
            while ((readed = ((InputStream)is).read(buffer)) > 0) {
                md.update(buffer, 0, readed);
            }
            ((InputStream)is).close();
            byte[] digest = md.digest();
            StringBuffer sBuffer = new StringBuffer(digest.length * 2);
            for (byte b : digest) {
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() == 1) {
                    sBuffer.append('0');
                }
                sBuffer.append(s);
            }
            string = sBuffer.toString();
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close(is);
            return string2;
        }
        IOUtil.close(is);
        return string;
    }

    public static String genShortHash(File file, int checkLength) {
        if (!file.isFile()) {
            return null;
        }
        if (file.length() < (long)(checkLength * 2)) {
            return IOUtil.genSHA1(file);
        }
        try {
            String start = null;
            String end = null;
            byte[] buffer = new byte[checkLength];
            FileInputStream is = new FileInputStream(file);
            is.read(buffer);
            is.close();
            start = EncodeUtil.genMD5(buffer);
            buffer = new byte[checkLength];
            is = new FileInputStream(file);
            is.skip(file.length() - (long)checkLength);
            is.read(buffer);
            is.close();
            end = EncodeUtil.genMD5(buffer);
            return start + end;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String genSHA1(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[131072];
            int readed = 0;
            while ((readed = is.read(buffer)) > 0) {
                md.update(buffer, 0, readed);
            }
            is.close();
            byte[] digest = md.digest();
            StringBuffer sBuffer = new StringBuffer(digest.length * 2);
            for (byte b : digest) {
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() == 1) {
                    sBuffer.append('0');
                }
                sBuffer.append(s);
            }
            return sBuffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void delete(File root) {
        if (root.isFile()) {
            root.delete();
            return;
        }
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                IOUtil.delete(file);
            }
        }
        root.delete();
    }

    public static String getFileExt(String fileName) {
        if (fileName == null) {
            return "";
        }
        int point = fileName.lastIndexOf(46);
        if (point != -1) {
            return fileName.substring(point + 1);
        }
        return "";
    }

    public static String getFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        int point = fileName.lastIndexOf(46);
        if (point != -1) {
            return fileName.substring(0, point);
        }
        return "";
    }

    public static String genPathSHA1(File file) {
        String path = file.getAbsolutePath();
        path = IOUtil.normalizeFileName(path);
        return EncodeUtil.genSHA1(path.getBytes());
    }

    public static String getCurrentDirectoryPath() {
        return new File(".").getAbsoluteFile().getParent();
    }

    public static File getCurrentDirectory() {
        return new File(".").getAbsoluteFile().getParentFile();
    }

    public static File[] sort(File[] files) {
        if (files == null) {
            return new File[0];
        }
        ArrayList<File> temp = new ArrayList<File>();
        for (File f : files) {
            temp.add(f);
        }
        Collections.sort(temp, new Comparator<File>(){

            @Override
            public int compare(File object1, File object2) {
                String f0 = object1.getAbsolutePath();
                String f1 = object2.getAbsolutePath();
                return StringUtil.compareString(f0, f1);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            files[i] = (File)temp.get(i);
        }
        return files;
    }

    public static String normalizeFileName(String origin) {
        origin = StringUtil.zenkakuEngToHankakuEng(origin);
        origin = StringUtil.macStringToWinString(origin);
        while (origin.indexOf(63) >= 0) {
            origin = origin.replace('?', '\uff1f');
        }
        return origin;
    }

    @Deprecated
    public static File mkdir(File dir) {
        return IOUtil.mkdirs(dir);
    }

    public static File mkdirs(File dir) {
        dir.mkdirs();
        return dir;
    }

    public static File[] listFiles(File dir) {
        if (dir == null) {
            return new File[0];
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return new File[0];
        }
        return files;
    }

    public static List<File> getDirectoryRoute(File target, File parent) {
        LinkedList<File> result = new LinkedList<File>();
        File current = target;
        while (!IOUtil.equals(current, parent)) {
            result.add(0, current);
            current = current.getParentFile();
        }
        result.add(0, parent);
        return result;
    }

    public static File cleanDirectory(File dir) {
        if (dir.isFile()) {
            return null;
        }
        IOUtil.delete(dir);
        dir.mkdirs();
        return dir;
    }

    public static boolean equals(File a, File b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getAbsolutePath().equals(b.getAbsolutePath());
    }

    public static boolean isGzip(byte[] buffer) {
        return buffer.length > 2 && buffer[0] == 31 && buffer[1] == -117;
    }

    public static byte[] compressGzip(byte[] raw) {
        try {
            ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bufferStream);
            gzipOutputStream.write(raw);
            gzipOutputStream.flush();
            gzipOutputStream.close();
            return bufferStream.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] decompressGzipOrNull(byte[] gzip) {
        try {
            GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(gzip));
            return IOUtil.toByteArray(is, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream stream, OnMemoryDecompressCallback callback) throws IOException {
        ZipInputStream is = null;
        try {
            ZipEntry entry;
            is = new ZipInputStream(stream);
            byte[] buffer = new byte[131072];
            while ((entry = is.getNextEntry()) != null && !callback.isCanceled()) {
                String path = entry.getName();
                if (entry.isDirectory() || !callback.isDecompressExist(entry.getSize(), path)) continue;
                ByteArrayOutputStream os = null;
                try {
                    int read;
                    os = new ByteArrayOutputStream((int)entry.getSize());
                    while ((read = is.read(buffer)) > 0) {
                        os.write(buffer, 0, read);
                        if (!callback.isCanceled()) continue;
                        throw new InterruptedIOException();
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(os);
                    throw throwable;
                }
                IOUtil.close(os);
                callback.onDecompressCompleted(path, os.toByteArray());
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(is);
            throw throwable;
        }
        IOUtil.close(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream stream, File outDirectory, DecompressCallback callback) throws IOException {
        ZipInputStream is = null;
        try {
            ZipEntry entry;
            is = new ZipInputStream(stream);
            byte[] buffer = new byte[131072];
            while ((entry = is.getNextEntry()) != null && !callback.isCanceled()) {
                File outFile = outDirectory;
                List<String> path = CollectionUtil.asList(entry.getName().split("/"));
                while (path.size() > 1) {
                    outFile = new File(outFile, path.remove(0));
                }
                outFile.mkdirs();
                outFile = new File(outFile, path.get(0));
                if (entry.isDirectory() || !callback.isDecompressExist(entry.getSize(), outFile)) continue;
                FileOutputStream os = null;
                try {
                    int read;
                    os = new FileOutputStream(outFile);
                    while ((read = is.read(buffer)) > 0) {
                        os.write(buffer, 0, read);
                        if (!callback.isCanceled()) continue;
                        throw new InterruptedIOException();
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(os);
                    throw throwable;
                }
                IOUtil.close(os);
                callback.onDecompressCompleted(outFile);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(is);
            throw throwable;
        }
        IOUtil.close(is);
    }

    @Deprecated
    public static void unzip(InputStream stream, File outDirectory) throws IOException {
        ZipEntry entry;
        ZipInputStream is = new ZipInputStream(stream);
        while ((entry = is.getNextEntry()) != null) {
            File outFile = outDirectory;
            List<String> path = CollectionUtil.asList(entry.getName().split("/"));
            while (path.size() > 1) {
                outFile = new File(outFile, path.remove(0));
            }
            outFile.mkdirs();
            outFile = new File(outFile, path.get(0));
            if (entry.isDirectory()) continue;
            FileOutputStream os = new FileOutputStream(outFile);
            IOUtil.copyTo(is, false, os, false);
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File outDirectory) throws IOException {
        FileInputStream is = new FileInputStream(zipFile);
        try {
            IOUtil.unzip((InputStream)is, outDirectory);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean close(Object obj) {
        block9: {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Closeable) {
                ((Closeable)obj).close();
                return true;
            }
            if (!(obj instanceof Disposable)) break block9;
            ((Disposable)obj).dispose();
            return true;
        }
        try {
            Method method = obj.getClass().getMethod("close", new Class[0]);
            method.invoke(obj, new Object[0]);
            return true;
        }
        catch (Exception method) {
            try {
                try {
                    Method method2 = obj.getClass().getMethod("dispose", new Class[0]);
                    method2.invoke(obj, new Object[0]);
                    return true;
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isFile(File file) {
        return file != null && file.isFile();
    }

    public static boolean isDirectory(File file) {
        return file != null && file.isDirectory();
    }

    public static interface DecompressCallback {
        public boolean isCanceled();

        public boolean isDecompressExist(long var1, File var3);

        public void onDecompressCompleted(File var1);
    }

    public static interface OnMemoryDecompressCallback {
        public boolean isCanceled();

        public boolean isDecompressExist(long var1, String var3);

        public void onDecompressCompleted(String var1, byte[] var2);
    }
}

