/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import com.eaglesakura.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;

public class EncodeUtil {
    public static String genMD5(byte[] buffer) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buffer);
            byte[] digest = md.digest();
            StringBuffer sBuffer = new StringBuffer(digest.length * 2);
            for (byte b : digest) {
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() == 1) {
                    sBuffer.append('0');
                }
                sBuffer.append(s);
            }
            return sBuffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String genMD5(InputStream is) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int readed = 0;
            while ((readed = is.read(buffer)) > 0) {
                md.update(buffer, 0, readed);
            }
            byte[] digest = md.digest();
            StringBuffer sBuffer = new StringBuffer(digest.length * 2);
            for (byte b : digest) {
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() == 1) {
                    sBuffer.append('0');
                }
                sBuffer.append(s);
            }
            return sBuffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String genSHA1(byte[] buffer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(buffer);
            byte[] digest = md.digest();
            StringBuffer sBuffer = new StringBuffer(digest.length * 2);
            for (byte b : digest) {
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() == 1) {
                    sBuffer.append('0');
                }
                sBuffer.append(s);
            }
            return sBuffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] compressOrRaw(byte[] buffer) {
        if (buffer.length > 1024) {
            byte[] resultBuffer = IOUtil.compressGzip(buffer);
            if (resultBuffer.length < buffer.length) {
                return resultBuffer;
            }
            return buffer;
        }
        return buffer;
    }

    public static byte[] decompressOrRaw(byte[] buffer) {
        if (IOUtil.isGzip(buffer)) {
            byte[] resultBuffer = IOUtil.decompressGzipOrNull(buffer);
            if (resultBuffer == null) {
                return buffer;
            }
            return resultBuffer;
        }
        return buffer;
    }

    public static long getHash64(byte[] buffer, long seed) {
        return EncodeUtil.getHash64(buffer, 0, buffer.length, seed);
    }

    public static long getHash64(byte[] buffer, int offset, int length, long seed) {
        long result = seed;
        while (length > 0) {
            result ^= (long)(buffer[offset] & 0xFF) * seed;
            seed = (seed << 7 | seed >>> 57) ^ 0xFFFFFFFFFFFFFFFFL;
            ++offset;
            --length;
        }
        return result;
    }

    public static String toUrl(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String fromUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            return url;
        }
    }
}

