/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import com.eaglesakura.util.StringUtil;
import com.eaglesakura.util.Timer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    private static final SimpleDateFormat ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final int DAY_MILLI_SEC = 86400000;

    public static String toISO8601(Date date) {
        return ISO8601.format(date);
    }

    public static Date parseDateISO8601(String value, TimeZone timeZone) {
        try {
            int timeZoneIndex = Math.max(value.lastIndexOf(43), value.lastIndexOf(45));
            if (value.length() < 20) {
                Calendar instance = Calendar.getInstance();
                instance.setTimeZone(timeZone);
                instance.setTime(ISO8601.parse(value));
                return instance.getTime();
            }
            String dateTimeString = value.substring(0, timeZoneIndex);
            String timeZoneString = StringUtil.replaceAllSimple(value.substring(timeZoneIndex + 1), ":", "");
            Date origin = ISO8601.parse(dateTimeString);
            int hour = Integer.valueOf(timeZoneString.substring(0, 2));
            int minutes = Integer.valueOf(timeZoneString.substring(2, 4));
            long dateOffset = value.charAt(timeZoneIndex) == '+' ? -Timer.toMilliSec(0, hour, minutes, 0, 0) : Timer.toMilliSec(0, hour, minutes, 0, 0);
            return new Date(origin.getTime() + (dateOffset += (long)timeZone.getRawOffset()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getYear(Calendar calendar) {
        return calendar.get(1);
    }

    public static int getYear(Date date, TimeZone zone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(zone);
        calendar.setTime(date);
        return DateUtil.getYear(calendar);
    }

    public static int getMonth(Calendar calendar) {
        return calendar.get(2) + 1;
    }

    public static int getMonth(Date date, TimeZone zone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(zone);
        calendar.setTime(date);
        return DateUtil.getMonth(calendar);
    }

    public static int getDay(Calendar calendar) {
        return calendar.get(5);
    }

    public static int getDay(Date date, TimeZone zone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(zone);
        calendar.setTime(date);
        return DateUtil.getDay(calendar);
    }

    public static int getHour(Calendar calendar) {
        return calendar.get(11);
    }

    public static int getHour(Date date, TimeZone zone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(zone);
        calendar.setTime(date);
        return DateUtil.getHour(calendar);
    }

    public static int getMinute(Calendar calendar) {
        return calendar.get(12);
    }

    public static int getMinute(Date date, TimeZone zone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(zone);
        calendar.setTime(date);
        return DateUtil.getMinute(calendar);
    }

    public static Date getTime(TimeZone timeZone, int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.set(year, month - 1, day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDateOffset() {
        return TimeZone.getDefault().getRawOffset();
    }

    public static Date getDateStart(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date offset(Date date, long time) {
        return new Date(date.getTime() + time);
    }

    @Deprecated
    public static Date getDateStart(Date date) {
        long now = date.getTime();
        return new Date(now / 86400000L * 86400000L);
    }

    @Deprecated
    public static Date getDateEnd(Date date) {
        return new Date(DateUtil.getDateStart(date).getTime() + 86400000L - 1L);
    }

    @Deprecated
    public static Date getTodayStart() {
        return DateUtil.getDateStart(new Date());
    }

    @Deprecated
    public static Date getTodayEnd() {
        return new Date(DateUtil.getTodayStart().getTime() + 86400000L - 1L);
    }
}

