/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import com.eaglesakura.lambda.Action1;
import com.eaglesakura.lambda.Action2;
import com.eaglesakura.lambda.Matcher1;
import com.eaglesakura.lambda.ResultAction1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static <T> int eachRemove(Collection<T> srcdst, Matcher1<T> execute) throws Throwable {
        int result = 0;
        Iterator<T> iterator = srcdst.iterator();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!execute.match(item)) continue;
            iterator.remove();
            ++result;
        }
        return result;
    }

    public static <T> int safeEachRemove(Collection<T> srcdst, Matcher1<T> execute) {
        try {
            return CollectionUtil.eachRemove(srcdst, execute);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> filter(List<T> src, List<T> dst, Matcher1<T> filter) throws Throwable {
        for (T it : src) {
            if (!filter.match(it)) continue;
            dst.add(it);
        }
        return dst;
    }

    public static <T> List<T> trimNull(List<T> srcDst) {
        Iterator<T> iterator = srcDst.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        return srcDst;
    }

    public static <T> Set<T> each(Set<T> set, Action1<T> action) throws Throwable {
        for (T it : set) {
            action.action(it);
        }
        return set;
    }

    public static <K, V> Map<K, V> each(Map<K, V> map, Action1<V> action) throws Throwable {
        for (V it : map.values()) {
            action.action(it);
        }
        return map;
    }

    public static <K, V> Map<K, V> each(Map<K, V> map, Action2<K, V> action) throws Throwable {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            action.action(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <T> List<T> each(List<T> list, Action1<T> action) throws Throwable {
        for (T it : list) {
            action.action(it);
        }
        return list;
    }

    public static <T> List<T> safeFilter(List<T> src, List<T> dst, Matcher1<T> filter) {
        try {
            return CollectionUtil.filter(src, dst, filter);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> safeEach(List<T> list, Action1<T> action) {
        try {
            return CollectionUtil.each(list, action);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> boolean addUnique(List<T> list, T item) {
        if (!list.contains(item)) {
            list.add(item);
            return true;
        }
        return false;
    }

    public static <T> int addUniqueRequestIndex(List<T> list, T item) {
        CollectionUtil.addUnique(list, item);
        return list.indexOf(item);
    }

    public static <T> T[] asArray(Collection<T> c, T[] array) {
        return c.toArray(array);
    }

    public static <T> List<T> asList(T[] array) {
        return new ArrayList<T>(Arrays.asList(array));
    }

    public static <T> List<T> addAll(List<T> list, Collection<T> items) {
        list.addAll(items);
        return list;
    }

    public static <T> T[] copyOf(T[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.copyOf(array, array.length);
    }

    public static <Key, Value> Map<Key, Value> asMap(Collection<Value> values, ResultAction1<Value, Key> keyCreator) {
        HashMap<Key, Value> result = new HashMap<Key, Value>();
        for (Value value : values) {
            try {
                result.put(keyCreator.action(value), value);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static <Key, Value> Map<Key, Value> asPairMap(Collection<Value> values, ResultAction1<Value, Key> keyCreator) {
        HashMap<Key, Value> result = new HashMap<Key, Value>();
        Iterator<Value> iterator = values.iterator();
        while (iterator.hasNext()) {
            try {
                Key key = keyCreator.action(iterator.next());
                Value value = iterator.next();
                result.put(key, value);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static <T, R> Set<R> asOtherSet(Iterable<T> origin, ResultAction1<T, R> converter) {
        HashSet<R> result = new HashSet<R>();
        for (T item : origin) {
            try {
                result.add(converter.action(item));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static <T, R> List<R> asOtherList(Iterable<T> origin, ResultAction1<T, R> converter) {
        ArrayList<R> result = new ArrayList<R>();
        for (T item : origin) {
            try {
                result.add(converter.action(item));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static <T, R> List<R> asOtherList(Iterator<T> origin, ResultAction1<T, R> converter) {
        ArrayList<R> result = new ArrayList<R>();
        while (origin.hasNext()) {
            try {
                result.add(converter.action(origin.next()));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static <K, V> K findKeyFromValue(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean isEmpty(byte[] item) {
        return item == null || item.length == 0;
    }

    public static <T> boolean isEmpty(T[] item) {
        return item == null || item.length == 0;
    }

    public static <T> boolean isEmpty(Collection<T> item) {
        return item == null || item.isEmpty();
    }

    public static boolean allNotNull(Object ... objects) {
        for (Object obj : objects) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }
}

