/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.math;

public final class Vector3 {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;

    public Vector3() {
    }

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Vector3 origin) {
        this.set(origin);
    }

    public void set(Vector3 origin) {
        this.x = origin.x;
        this.y = origin.y;
        this.z = origin.z;
    }

    public void mul(float _x, float _y, float _z) {
        this.x *= _x;
        this.y *= _y;
        this.z *= _z;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float dot(Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public float dot(float _x, float _y, float _z) {
        return this.x * _x + this.y * _y + this.z * _z;
    }

    public Vector3 cross(Vector3 v, Vector3 result) {
        result.set(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
        return result;
    }

    public void cross(float _x, float _y, float _z) {
        this.set(this.y * _z - this.z * _y, this.z * _x - this.x * _z, this.x * _y - this.y * _x);
    }

    public void sub(Vector3 v0, Vector3 v1) {
        this.x = v0.x - v1.x;
        this.y = v0.y - v1.y;
        this.z = v0.z - v1.z;
    }

    public void add(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void add(float _x, float _y, float _z) {
        this.x += _x;
        this.y += _y;
        this.z += _z;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float length(Vector3 v) {
        float _x = this.x - v.x;
        float _y = this.y - v.y;
        float _z = this.z - v.z;
        return (float)Math.sqrt(_x * _x + _y * _y + _z * _z);
    }

    public void normalize() {
        float len = this.length();
        this.x /= len;
        this.y /= len;
        this.z /= len;
    }

    public static void leap(Vector3 v0, Vector3 v1, float leap, Vector3 result) {
        result.x = v1.x * leap + v0.x * (1.0f - leap);
        result.y = v1.y * leap + v0.y * (1.0f - leap);
        result.z = v1.z * leap + v0.z * (1.0f - leap);
    }

    public boolean equals(Object obj) {
        Vector3 v = (Vector3)obj;
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public float max() {
        return Math.max(Math.max(this.x, this.y), this.z);
    }

    public float min() {
        return Math.min(Math.min(this.x, this.y), this.z);
    }

    public String toString() {
        return "V( " + this.x + ", " + this.y + ", " + this.z + " )";
    }
}

