/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.math;

import com.eaglesakura.util.MathUtil;

public final class Vector2 {
    public float x = 0.0f;
    public float y = 0.0f;

    public Vector2() {
    }

    public Vector2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(Vector2 origin) {
        this.set(origin);
    }

    public void set(Vector2 origin) {
        this.x = origin.x;
        this.y = origin.y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float dot(Vector2 v) {
        return this.x * v.x + this.y * v.y;
    }

    public void mul(float mul) {
        this.x *= mul;
        this.y *= mul;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float length(Vector2 p) {
        float tx = this.x - p.x;
        float ty = this.y - p.y;
        return (float)Math.sqrt(tx * tx + ty * ty);
    }

    public float length(float px, float py) {
        float tx = this.x - px;
        float ty = this.y - py;
        return (float)Math.sqrt(tx * tx + ty * ty);
    }

    public static float length(float px0, float py0, float px1, float py1) {
        float tx = px0 - px1;
        float ty = py0 - py1;
        return (float)Math.sqrt(tx * tx + ty * ty);
    }

    public static double length(double px0, double py0, double px1, double py1) {
        double tx = px0 - px1;
        double ty = py0 - py1;
        return Math.sqrt(tx * tx + ty * ty);
    }

    public void normalize() {
        float len = this.length();
        if (len == 0.0f) {
            return;
        }
        this.x /= len;
        this.y /= len;
    }

    public boolean equals(Object obj) {
        Vector2 v = (Vector2)obj;
        return this.x == v.x && this.y == v.y;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "V( " + this.x + ", " + this.y + " )";
    }

    public static double degree(Vector2 p0, Vector2 p1) {
        double length = Vector2.length(p0.x, p0.y, p1.x, p1.y);
        if (length == 0.0) {
            return 0.0;
        }
        double vecX = (double)(p1.x - p0.x) / length;
        double vecY = (double)(p1.y - p0.y) / length;
        double radian = Math.atan2(vecX, vecY);
        return MathUtil.normalizeDegree(360.0 - radian * 180.0 / Math.PI);
    }
}

