/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.io;

import com.eaglesakura.lambda.CancelCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class CancelableInputStream
extends InputStream {
    final InputStream mStream;
    int mBufferSize = 2048;
    final CancelCallback mCancelCallback;

    public CancelableInputStream(InputStream stream, CancelCallback cancelCallback) {
        this.mStream = stream;
        this.mCancelCallback = cancelCallback;
        if (this.mStream == null || this.mCancelCallback == null) {
            throw new IllegalArgumentException();
        }
    }

    public void setBufferSize(int bufferSize) {
        this.mBufferSize = bufferSize;
        if (this.mBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
    }

    private void throwIfCanceled() throws IOException {
        try {
            if (this.mCancelCallback.isCanceled()) {
                throw new InterruptedIOException();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        this.read(buf, 0, 1);
        return buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        this.throwIfCanceled();
        return this.mStream.read(buffer, byteOffset, Math.min(this.mBufferSize, byteCount));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.mStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.mStream.available();
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.mStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.mStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.mStream.markSupported();
    }
}

