/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.collection;

import com.eaglesakura.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StringFlag {
    static final char SEPARATOR = ',';
    Set<String> mFlags = new HashSet<String>();
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareTo(b);
        }
    };

    public StringFlag() {
    }

    public StringFlag(Object ... flags) {
        for (Object flag : flags) {
            if (flag instanceof Iterable) {
                for (Object f : (Iterable)flag) {
                    this.add(f);
                }
                continue;
            }
            this.add(flag);
        }
    }

    public boolean contains(Object flag) {
        return this.mFlags.contains(flag.toString());
    }

    public StringFlag add(Object flag) {
        String strFlag = flag.toString();
        if (strFlag.indexOf(44) >= 0) {
            throw new IllegalArgumentException(strFlag);
        }
        this.mFlags.add(strFlag);
        return this;
    }

    public StringFlag add(StringFlag flag) {
        this.mFlags.addAll(flag.mFlags);
        return this;
    }

    private List<String> toList() {
        ArrayList<String> list = new ArrayList<String>(this.mFlags);
        Collections.sort(list, COMPARATOR);
        return list;
    }

    public String toLikeQuery() {
        if (this.mFlags.isEmpty()) {
            return ",,,";
        }
        StringBuilder builder = new StringBuilder();
        for (String flag : this.toList()) {
            builder.append("%").append(',').append(flag).append(',');
        }
        return builder.append("%").toString();
    }

    public String toString() {
        if (this.mFlags.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String flag : this.toList()) {
            builder.append(',').append(flag);
        }
        builder.append(',');
        return builder.toString();
    }

    public static StringFlag parse(String flags) {
        StringFlag result = new StringFlag();
        if (StringUtil.isEmpty(flags)) {
            return result;
        }
        for (String flag : flags.split(String.valueOf(','))) {
            if (StringUtil.isEmpty(flag)) continue;
            result.add(flag);
        }
        return result;
    }

    public static String or(String aFlags, String bFlags) {
        StringFlag flagA = StringFlag.parse(aFlags);
        StringFlag flagB = StringFlag.parse(bFlags);
        return flagA.add(flagB).toString();
    }
}

