/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.collection;

import com.eaglesakura.lambda.Action1;
import com.eaglesakura.lambda.Action2;
import com.eaglesakura.lambda.Matcher1;
import com.eaglesakura.lambda.ResultAction1;
import com.eaglesakura.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DataCollection<T> {
    final List<T> mDataList;
    Comparator<T> mComparator;

    public DataCollection(List<T> dataList) {
        this.mDataList = dataList;
    }

    public DataCollection() {
        this.mDataList = new ArrayList<T>();
    }

    public DataCollection<T> setComparator(Comparator<T> comparator) {
        this.mComparator = comparator;
        return this;
    }

    public int size() {
        return this.mDataList.size();
    }

    public boolean isEmpty() {
        return this.mDataList.isEmpty();
    }

    public void each(Action1<T> action) throws Throwable {
        for (T data : this.mDataList) {
            action.action(data);
        }
    }

    public void each(Action2<Integer, T> action) throws Throwable {
        int index = 0;
        for (T data : this.mDataList) {
            action.action(index, (Integer)data);
            ++index;
        }
    }

    public void safeEach(Action1<T> action) {
        try {
            for (T data : this.mDataList) {
                action.action(data);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void safeEach(Action2<Integer, T> action) {
        try {
            int index = 0;
            for (T data : this.mDataList) {
                action.action(index, (Integer)data);
                ++index;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void sortEach(Action1<T> action) throws Throwable {
        for (T data : this.list()) {
            action.action(data);
        }
    }

    public void sortEach(Action2<Integer, T> action) throws Throwable {
        int index = 0;
        for (T data : this.list()) {
            action.action(index, (Integer)data);
            ++index;
        }
    }

    public void sortSafeEach(Action2<Integer, T> action) {
        try {
            int index = 0;
            for (T data : this.list()) {
                action.action(index, (Integer)data);
                ++index;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public <Key> Map<Key, T> asMap(Matcher1<T> filter, ResultAction1<T, Key> keyConvert) {
        return CollectionUtil.asMap(this.list(filter, false), keyConvert);
    }

    protected List<T> newList(int size) {
        return new ArrayList(size);
    }

    protected void sort(List<T> items) {
        if (this.mComparator != null) {
            Collections.sort(items, this.mComparator);
        }
    }

    public List<T> getSource() {
        return this.mDataList;
    }

    public List<T> list() {
        return this.list(new Matcher1<T>(){

            @Override
            public boolean match(T it) throws Throwable {
                return true;
            }
        }, true);
    }

    public T find(Matcher1<T> filter) {
        return this.find(filter, 0);
    }

    public T find(Matcher1<T> filter, int n) {
        try {
            int index = 0;
            for (T it : this.mDataList) {
                if (!filter.match(it)) continue;
                if (index == n) {
                    return it;
                }
                ++index;
            }
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public T findWithSort(Matcher1<T> filter) {
        try {
            for (T it : this.list()) {
                if (!filter.match(it)) continue;
                return it;
            }
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public T findWithSort(Matcher1<T> filter, int n) {
        try {
            int index = 0;
            for (T it : this.list()) {
                if (!filter.match(it)) continue;
                if (index == n) {
                    return it;
                }
                ++index;
            }
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> list(Matcher1<T> filter) {
        return this.list(filter, true);
    }

    public List<T> list(Matcher1<T> filter, boolean sort) {
        try {
            List<T> result = this.newList(this.mDataList.size());
            for (T item : this.mDataList) {
                if (!filter.match(item)) continue;
                result.add(item);
            }
            if (sort) {
                this.sort(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

