/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.collection;

import com.eaglesakura.lambda.Action1;
import com.eaglesakura.util.ReflectionUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AnonymousBroadcaster {
    Set<Item> mObjects = new HashSet<Item>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact() {
        AnonymousBroadcaster anonymousBroadcaster = this;
        synchronized (anonymousBroadcaster) {
            Iterator<Item> iterator = this.mObjects.iterator();
            while (iterator.hasNext()) {
                Item item = iterator.next();
                if (item.get() != null) continue;
                iterator.remove();
            }
        }
    }

    public <T> List<T> list(Class<T> clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.compact();
        for (Item item : this.mObjects) {
            Object ref = item.get();
            if (!ReflectionUtil.instanceOf(ref, clazz)) continue;
            result.add(ref);
        }
        return result;
    }

    public <T> void safeEach(Class<T> clazz, Action1<T> action) {
        try {
            for (T item : this.list(clazz)) {
                action.action(item);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public AnonymousBroadcaster register(Object obj) {
        this.compact();
        this.mObjects.add(new Item().ref(obj));
        return this;
    }

    public AnonymousBroadcaster weakRegister(Object obj) {
        this.compact();
        this.mObjects.add(new Item().ref(obj));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnonymousBroadcaster unregister(Object obj) {
        this.compact();
        AnonymousBroadcaster anonymousBroadcaster = this;
        synchronized (anonymousBroadcaster) {
            Iterator<Item> iterator = this.mObjects.iterator();
            while (iterator.hasNext()) {
                Item item = iterator.next();
                if (item.get() != obj) continue;
                iterator.remove();
            }
        }
        return this;
    }

    private class Item {
        Object mRef;
        WeakReference<Object> mWeakRef;
        long mHashCode;

        private Item() {
        }

        public Item weak(Object obj) {
            this.mHashCode = obj.hashCode();
            this.mWeakRef = new WeakReference<Object>(obj);
            this.mHashCode = (long)obj.hashCode() << 32 | (long)obj.getClass().hashCode() & 0xFFFFFFFFL;
            return this;
        }

        public Item ref(Object obj) {
            this.mRef = obj;
            this.mHashCode = (long)obj.hashCode() << 32 | (long)obj.getClass().hashCode() & 0xFFFFFFFFL;
            return this;
        }

        public Object get() {
            if (this.mRef != null) {
                return this.mRef;
            }
            return this.mWeakRef.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item that = (Item)o;
            return this.mHashCode == that.mHashCode;
        }

        public int hashCode() {
            return Long.valueOf(this.mHashCode).hashCode();
        }
    }
}

