/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.log;

import java.lang.reflect.Method;
import java.util.Locale;

public class Logger {
    private static Impl sLogger = null;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_DEBUG = 2;
    public static final int LEVEL_ERROR = 3;

    static void initLogger() {
        if (sLogger == null) {
            try {
                sLogger = new AndroidLogger(Class.forName("android.util.Log"));
            }
            catch (Exception e) {
                sLogger = new BasicLogger();
            }
        }
    }

    public static void out(int level, String tag, String fmt, Object ... args) {
        sLogger.out(level, tag, String.format(Locale.US, fmt, args));
    }

    public static void out(String tag, Exception e) {
        e.printStackTrace();
    }

    public static void setLogger(Impl logger) {
        sLogger = logger;
    }

    static {
        Logger.initLogger();
    }

    public static class RobolectricLogger
    implements Impl {
        protected int getStackDepth() {
            return 2;
        }

        @Override
        public void out(int level, String tag, String msg) {
            switch (level) {
                case 1: {
                    tag = "I/" + tag;
                    break;
                }
                case 3: {
                    tag = "E/" + tag;
                    break;
                }
                default: {
                    tag = "D/" + tag;
                }
            }
            try {
                StackTraceElement[] trace = new Exception().getStackTrace();
                StackTraceElement elem = trace[Math.min(trace.length - 1, this.getStackDepth())];
                if (level == 3) {
                    System.err.println(String.format("%s | %s[%d] : %s", tag, elem.getFileName(), elem.getLineNumber(), msg));
                } else {
                    System.out.println(String.format("%s | %s[%d] : %s", tag, elem.getFileName(), elem.getLineNumber(), msg));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class BasicLogger
    implements Impl {
        BasicLogger() {
        }

        @Override
        public void out(int level, String tag, String msg) {
            StackTraceElement[] trace = new Exception().getStackTrace();
            StackTraceElement elem = trace[Math.min(trace.length - 1, 2)];
            if (level == 3) {
                System.err.println(String.format("%s[%d] | %s | %s", elem.getFileName(), elem.getLineNumber(), tag, msg));
            } else {
                System.out.println(String.format(level == 2 ? "[DBG] | %s[%d] | %s | %s" : "%s[%d] | %s | %s", elem.getFileName(), elem.getLineNumber(), tag, msg));
            }
        }
    }

    public static class AndroidLogger
    implements Impl {
        private Class<?> clazz;
        private Method i;
        private Method d;
        private Method w;
        private boolean stackInfo = false;

        public AndroidLogger(Class<?> logClass) {
            this.clazz = logClass;
            try {
                this.i = this.clazz.getMethod("i", String.class, String.class);
                this.d = this.clazz.getMethod("d", String.class, String.class);
                this.w = this.clazz.getMethod("w", String.class, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public AndroidLogger setStackInfo(boolean stackInfo) {
            this.stackInfo = stackInfo;
            return this;
        }

        protected int getStackDepth() {
            return 2;
        }

        @Override
        public void out(int level, String tag, String msg) {
            try {
                Method method;
                switch (level) {
                    case 1: {
                        method = this.i;
                        break;
                    }
                    case 3: {
                        method = this.w;
                        break;
                    }
                    default: {
                        method = this.d;
                    }
                }
                if (this.stackInfo) {
                    StackTraceElement[] trace = new Exception().getStackTrace();
                    StackTraceElement elem = trace[Math.min(trace.length - 1, this.getStackDepth())];
                    String message = String.format("%s[%d] : %s", elem.getFileName(), elem.getLineNumber(), msg);
                    method.invoke(this.clazz, tag, message);
                } else {
                    method.invoke(this.clazz, tag, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface Impl {
        public void out(int var1, String var2, String var3);
    }
}

