/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class LogUtil {
    private static Logger sLogger = null;
    private static Map<String, LogOpt> sOptions = new HashMap<String, LogOpt>();
    public static final int LOGGER_LEVEL_INFO = 1;
    public static final int LOGGER_LEVEL_DEBUG = 2;
    public static final int LOGGER_LEVEL_ERROR = 3;

    static void initLogger() {
        if (sLogger == null) {
            try {
                sLogger = new AndroidLogger(Class.forName("android.util.Log"));
            }
            catch (Exception e) {
                sLogger = new BasicLogger();
            }
        }
    }

    private static synchronized LogOpt getOption(String tag) {
        LogOpt opt = sOptions.get(tag);
        if (opt == null) {
            opt = new LogOpt();
            sOptions.put(tag, opt);
        }
        return opt;
    }

    public static void setLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException();
        }
        sLogger = logger;
    }

    public static void setLogLevel(String tag, int level) {
        LogUtil.getOption((String)tag).level = level;
    }

    public static void setLogger(String tag, Logger logger) {
        if (logger == null) {
            logger = sLogger;
        }
        LogUtil.getOption((String)tag).logger = logger;
    }

    public static void setLogEnable(String tag, boolean enabled) {
        LogUtil.getOption((String)tag).enable = enabled;
    }

    public static void out(String tag, String fmt, Object ... args) {
        LogOpt opt = LogUtil.getOption(tag);
        if (!opt.enable) {
            return;
        }
        opt.logger.out(opt.level, tag, String.format(fmt, args));
    }

    public static void out(String tag, Exception e) {
        LogOpt opt = LogUtil.getOption(tag);
        if (!opt.enable) {
            return;
        }
        e.printStackTrace();
    }

    @Deprecated
    public static void log(String fmt, Object ... args) {
        String tag = ".lib";
        LogOpt opt = LogUtil.getOption(tag);
        if (!opt.enable) {
            return;
        }
        opt.logger.out(opt.level, tag, String.format(fmt, args));
    }

    @Deprecated
    public static void log(Exception e) {
        LogOpt opt = LogUtil.getOption(".lib");
        if (!opt.enable) {
            return;
        }
        e.printStackTrace();
    }

    static /* synthetic */ Logger access$000() {
        return sLogger;
    }

    static {
        LogUtil.initLogger();
    }

    public static class RobolectricLogger
    implements Logger {
        protected int getStackDepth() {
            return 2;
        }

        @Override
        public void out(int level, String tag, String msg) {
            switch (level) {
                case 1: {
                    tag = "I/" + tag;
                    break;
                }
                case 3: {
                    tag = "E/" + tag;
                    break;
                }
                default: {
                    tag = "D/" + tag;
                }
            }
            try {
                StackTraceElement[] trace = new Exception().getStackTrace();
                StackTraceElement elem = trace[Math.min(trace.length - 1, this.getStackDepth())];
                if (level == 3) {
                    System.err.println(String.format("%s | %s[%d] : %s", tag, elem.getFileName(), elem.getLineNumber(), msg));
                } else {
                    System.out.println(String.format("%s | %s[%d] : %s", tag, elem.getFileName(), elem.getLineNumber(), msg));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class BasicLogger
    implements Logger {
        BasicLogger() {
        }

        @Override
        public void out(int level, String tag, String msg) {
            StackTraceElement[] trace = new Exception().getStackTrace();
            StackTraceElement elem = trace[Math.min(trace.length - 1, 2)];
            if (level == 3) {
                System.err.println(String.format("%s[%d] | %s | %s", elem.getFileName(), elem.getLineNumber(), tag, msg));
            } else {
                System.out.println(String.format(level == 2 ? "[DBG] | %s[%d] | %s | %s" : "%s[%d] | %s | %s", elem.getFileName(), elem.getLineNumber(), tag, msg));
            }
        }
    }

    public static class AndroidLogger
    implements Logger {
        private Class<?> clazz;
        private Method i;
        private Method d;
        private Method w;
        private boolean stackInfo = false;

        public AndroidLogger(Class<?> logClass) {
            this.clazz = logClass;
            try {
                this.i = this.clazz.getMethod("i", String.class, String.class);
                this.d = this.clazz.getMethod("d", String.class, String.class);
                this.w = this.clazz.getMethod("w", String.class, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public AndroidLogger setStackInfo(boolean stackInfo) {
            this.stackInfo = stackInfo;
            return this;
        }

        protected int getStackDepth() {
            return 2;
        }

        @Override
        public void out(int level, String tag, String msg) {
            try {
                Method method;
                switch (level) {
                    case 1: {
                        method = this.i;
                        break;
                    }
                    case 3: {
                        method = this.w;
                        break;
                    }
                    default: {
                        method = this.d;
                    }
                }
                if (this.stackInfo) {
                    StackTraceElement[] trace = new Exception().getStackTrace();
                    StackTraceElement elem = trace[Math.min(trace.length - 1, this.getStackDepth())];
                    String message = String.format("%s[%d] : %s", elem.getFileName(), elem.getLineNumber(), msg);
                    method.invoke(this.clazz, tag, message);
                } else {
                    method.invoke(this.clazz, tag, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface Logger {
        public void out(int var1, String var2, String var3);
    }

    private static class LogOpt {
        boolean enable = true;
        int level = 1;
        Logger logger = LogUtil.access$000();

        private LogOpt() {
        }
    }
}

