/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjlog;

import android.os.Environment;
import android.util.Log;
import de.mindpipe.android.logging.log4j.LogConfigurator;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class ZJLogConfig {
    private String mTAG = "ZJLog";
    private String mFileName = null;
    private String mPathDic = null;
    private int mFileCount = 5;
    private int mFileSize = 10;
    public boolean isDebug = true;
    public boolean isSave = false;

    public void setTAG(String tag) {
        this.mTAG = tag;
    }

    public String getTAG() {
        return this.mTAG;
    }

    public void setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setSaveEnable(boolean need) {
        this.isSave = need;
    }

    public void setFileName(String name) {
        this.mFileName = name;
    }

    public void setSavePathDic(String pathDic) {
        this.mPathDic = pathDic;
    }

    public void setSaveFileCount(int count) {
        if (count > 0) {
            this.mFileCount = count;
        }
    }

    public void setSaveFileSize(int size) {
        if (size > 0) {
            this.mFileSize = size;
        }
    }

    public String getLogFileDir() {
        if (this.mPathDic != null) {
            if (!this.mPathDic.endsWith("/")) {
                this.mPathDic = this.mPathDic + File.separator;
            }
            return this.mPathDic;
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "ZJLog" + File.separator;
    }

    public String getLogFilePath() {
        String filePath = this.getLogFileDir() + "ZJLog.log";
        if (this.mFileName != null) {
            filePath = this.getLogFileDir() + this.mFileName + ".log";
        }
        return filePath;
    }

    public boolean configure() {
        File file;
        File filePath = new File(this.getLogFileDir());
        if (!filePath.exists() && !filePath.mkdirs()) {
            Log.e((String)"ZJLog", (String)("Failed to create new dir:" + this.getLogFileDir()));
        }
        if (!(file = new File(this.getLogFilePath())).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.e((String)"ZJLog", (String)("Failed to create new file:" + this.getLogFilePath()));
            }
        }
        LogConfigurator logConfigurator = new LogConfigurator();
        try {
            logConfigurator.setFileName(this.getLogFilePath());
            logConfigurator.setRootLevel(Level.ALL);
            logConfigurator.setLevel("Eafy", Level.ALL);
            logConfigurator.setMaxFileSize((long)(0x100000 * this.mFileSize));
            logConfigurator.setMaxBackupSize(this.mFileCount);
            logConfigurator.setUseLogCatAppender(true);
            logConfigurator.configure();
            return true;
        }
        catch (Throwable throwable) {
            this.isSave = false;
            logConfigurator.setResetConfiguration(true);
            Log.e((String)this.mTAG, (String)("ZJLog config is error, Error:" + throwable));
            return false;
        }
    }

    public Appender appender() {
        RollingFileAppender rollingFileAppender = null;
        try {
            PatternLayout patternLayout = new PatternLayout("%d{yyy-MM-dd HH:mm:ss,SSS} [%p::%C:%x] %m%n");
            rollingFileAppender = new RollingFileAppender((Layout)patternLayout, this.getLogFilePath());
            rollingFileAppender.setMaximumFileSize((long)(0x100000 * this.mFileSize));
            rollingFileAppender.setMaxBackupIndex(this.mFileCount);
            rollingFileAppender.setName(this.mTAG);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)this.mTAG, (String)("ZJLog file appender is error, Error:" + e.getMessage()));
        }
        return rollingFileAppender;
    }
}

