/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjlog;

import android.util.Log;
import com.eafy.zjlog.ZJLogConfig;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class ZJLog {
    private static Logger mLogger = null;
    public static ZJLogConfig config = new ZJLogConfig();

    private static ZJLogConfig getConfig() {
        if (config == null) {
            config = new ZJLogConfig();
        }
        return config;
    }

    private static Logger getLoger(ZJLogConfig config, String tag) {
        Appender apr;
        if (config != null && mLogger == null) {
            config.configure();
            mLogger = Logger.getLogger((String)tag);
            if (config != ZJLog.getConfig()) {
                mLogger.addAppender(config.appender());
                mLogger.setAdditivity(false);
            }
        }
        if (mLogger != null && !tag.equals(mLogger.getName()) && (apr = (mLogger = Logger.getLogger((String)tag)).getAppender(tag)) == null && config != ZJLog.getConfig()) {
            mLogger.addAppender(config.appender());
            mLogger.setAdditivity(false);
        }
        return mLogger;
    }

    private static boolean saveToLoger(ZJLogConfig config, String tag, String msg, int prio) {
        if (config != null && config.isDebug && msg != null && config.isSave) {
            switch (prio) {
                case 6: {
                    ZJLog.getLoger(config, tag).error((Object)msg);
                    break;
                }
                case 4: {
                    ZJLog.getLoger(config, tag).info((Object)msg);
                    break;
                }
                case 5: {
                    ZJLog.getLoger(config, tag).warn((Object)msg);
                    break;
                }
                default: {
                    ZJLog.getLoger(config, tag).debug((Object)msg);
                }
            }
            return true;
        }
        return false;
    }

    public static void v(ZJLogConfig config, String tag, String msg) {
        if (!ZJLog.saveToLoger(config, tag, msg, 2)) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void d(ZJLogConfig config, String tag, String msg) {
        if (!ZJLog.saveToLoger(config, tag, msg, 3)) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void i(ZJLogConfig config, String tag, String msg) {
        if (!ZJLog.saveToLoger(config, tag, msg, 4)) {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void w(ZJLogConfig config, String tag, String msg) {
        if (!ZJLog.saveToLoger(config, tag, msg, 5)) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void e(ZJLogConfig config, String tag, String msg) {
        if (!ZJLog.saveToLoger(config, tag, msg, 6)) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void v(String tag, String msg) {
        ZJLog.v(ZJLog.getConfig(), tag, msg);
    }

    public static void d(String tag, String msg) {
        ZJLog.d(ZJLog.getConfig(), tag, msg);
    }

    public static void i(String tag, String msg) {
        ZJLog.i(ZJLog.getConfig(), tag, msg);
    }

    public static void w(String tag, String msg) {
        ZJLog.w(ZJLog.getConfig(), tag, msg);
    }

    public static void e(String tag, String msg) {
        ZJLog.e(ZJLog.getConfig(), tag, msg);
    }

    public static void v(String msg) {
        ZJLog.v(ZJLog.getConfig(), ZJLog.getConfig().getTAG(), msg);
    }

    public static void d(String msg) {
        ZJLog.d(ZJLog.getConfig(), ZJLog.getConfig().getTAG(), msg);
    }

    public static void i(String msg) {
        ZJLog.i(ZJLog.getConfig(), ZJLog.getConfig().getTAG(), msg);
    }

    public static void w(String msg) {
        ZJLog.w(ZJLog.getConfig(), ZJLog.getConfig().getTAG(), msg);
    }

    public static void e(String msg) {
        ZJLog.e(ZJLog.getConfig(), ZJLog.getConfig().getTAG(), msg);
    }

    public static void log(int prio, String msg) {
        if (prio == 2) {
            ZJLog.v(msg);
        } else if (prio == 3) {
            ZJLog.d(msg);
        } else if (prio == 4) {
            ZJLog.i(msg);
        } else if (prio == 5) {
            ZJLog.w(msg);
        } else if (prio == 6) {
            ZJLog.e(msg);
        } else {
            ZJLog.d(msg);
        }
    }

    public static void log(String msg) {
        ZJLog.d(ZJLog.getConfig(), ZJLog.getConfig().getTAG(), msg);
    }

    public static void printBytes(String logHint, byte[] buffer) {
        String finalString = logHint;
        for (int i = 0; i < buffer.length; ++i) {
            String hex = Integer.toHexString(buffer[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            finalString = finalString == null ? hex : finalString + " " + hex;
        }
        ZJLog.d(finalString);
    }
}

