/*
 * Decompiled with CFR 0.152.
 */
package com.ea.async.instrumentation;

import com.ea.async.instrumentation.FrameAnalyzer;
import com.ea.async.shaded.org.objectweb.asm.ClassReader;
import com.ea.async.shaded.org.objectweb.asm.ClassWriter;
import com.ea.async.shaded.org.objectweb.asm.Handle;
import com.ea.async.shaded.org.objectweb.asm.Label;
import com.ea.async.shaded.org.objectweb.asm.MethodVisitor;
import com.ea.async.shaded.org.objectweb.asm.Opcodes;
import com.ea.async.shaded.org.objectweb.asm.Type;
import com.ea.async.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import com.ea.async.shaded.org.objectweb.asm.tree.ClassNode;
import com.ea.async.shaded.org.objectweb.asm.tree.FrameNode;
import com.ea.async.shaded.org.objectweb.asm.tree.InsnList;
import com.ea.async.shaded.org.objectweb.asm.tree.InsnNode;
import com.ea.async.shaded.org.objectweb.asm.tree.LabelNode;
import com.ea.async.shaded.org.objectweb.asm.tree.LocalVariableNode;
import com.ea.async.shaded.org.objectweb.asm.tree.MethodInsnNode;
import com.ea.async.shaded.org.objectweb.asm.tree.MethodNode;
import com.ea.async.shaded.org.objectweb.asm.tree.TypeInsnNode;
import com.ea.async.shaded.org.objectweb.asm.tree.VarInsnNode;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.BasicValue;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.Frame;
import com.ea.async.shaded.org.objectweb.asm.tree.analysis.Value;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Transformer
implements ClassFileTransformer {
    static final String EA_ASYNC_RUNNING = "ea-async.running";
    private static final String ASYNC_NAME = "com/ea/async/Async";
    public static final String ASYNC_METHOD_NAME = "await";
    public static final String ASYNC_INIT_METHOD_DESC = "()V";
    public static final String ASYNC_INIT_METHOD_NAME = "init";
    private static final String COMPLETABLE_FUTURE_DESCRIPTOR = "Ljava/util/concurrent/CompletableFuture;";
    private static final Type COMPLETABLE_FUTURE_TYPE = Type.getType("Ljava/util/concurrent/CompletableFuture;");
    private static final String COMPLETABLE_FUTURE_RET = ")Ljava/util/concurrent/CompletableFuture;";
    private static final String COMPLETABLE_FUTURE_NAME = "java/util/concurrent/CompletableFuture";
    private static final Type COMPLETION_STAGE_TYPE = Type.getType("Ljava/util/concurrent/CompletionStage;");
    private static final String COMPLETION_STAGE_NAME = "java/util/concurrent/CompletionStage";
    private static final String COMPLETION_STAGE_RET = ")Ljava/util/concurrent/CompletionStage;";
    private static final String _THIS = "_this";
    private static final Type ACONST_NULL_TYPE = Type.getObjectType("null");
    public static final String JOIN_METHOD_NAME = "join";
    public static final String JOIN_METHOD_DESC = "()Ljava/lang/Object;";
    public static final String LAMBDA_DESC = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
    public static final Handle METAFACTORY_HANDLE = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;");
    public static WeakHashMap<URL, Boolean> futureMap = new WeakHashMap();
    public static WeakHashMap<ClassLoader, Set<URL>> classLoaderMap = new WeakHashMap();
    private Consumer<String> errorListener;

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (className != null && className.startsWith("java")) {
                return null;
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            if (this.needsInstrumentation(cr)) {
                return this.transform(loader, cr);
            }
            return null;
        }
        catch (Error | Exception e) {
            RuntimeException exception = new RuntimeException("Error instrumenting: " + className, e);
            exception.printStackTrace();
            throw exception;
        }
    }

    public byte[] instrument(ClassLoader classLoader, InputStream inputStream) {
        try {
            ClassReader cr = new ClassReader(inputStream);
            if (this.needsInstrumentation(cr)) {
                return this.transform(classLoader, cr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public byte[] transform(ClassLoader classLoader, final ClassReader cr) throws AnalyzerException {
        ClassNode classNode = new ClassNode();
        cr.accept(classNode, 8);
        int countInstrumented = 0;
        HashMap<String, Integer> nameUseCount = new HashMap<String, Integer>();
        for (final MethodNode original : new ArrayList<MethodNode>(classNode.methods)) {
            boolean nonCompFutReturn;
            Integer countOriginalUses = (Integer)nameUseCount.get(original.name);
            nameUseCount.put(original.name, countOriginalUses == null ? 1 : countOriginalUses + 1);
            boolean hasAwaitCall = false;
            boolean hasAwaitInitCall = false;
            ListIterator<AbstractInsnNode> it = original.instructions.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof MethodInsnNode)) continue;
                if (!hasAwaitCall) {
                    hasAwaitCall = this.isAwaitCall((MethodInsnNode)o);
                }
                if (hasAwaitInitCall) continue;
                hasAwaitInitCall = this.isAwaitInitCall((MethodInsnNode)o);
            }
            if (!hasAwaitCall && !hasAwaitInitCall) continue;
            ++countInstrumented;
            boolean bl = nonCompFutReturn = !original.desc.endsWith(COMPLETABLE_FUTURE_RET) && !original.desc.endsWith(COMPLETION_STAGE_RET);
            if (original.desc.endsWith(COMPLETABLE_FUTURE_RET) || original.desc.endsWith(COMPLETION_STAGE_RET) || this.returnsCompletionStageSubClass(classLoader, original)) {
                this.transformAsyncMethod(classNode, original, nameUseCount);
                continue;
            }
            MethodNode replacement = new MethodNode(original.access, original.name, original.desc, original.signature, original.exceptions.toArray(new String[original.exceptions.size()]));
            class MyMethodVisitor
            extends MethodVisitor {
                public MyMethodVisitor(MethodNode mv) {
                    super(327680, mv);
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    if (Transformer.this.isAwaitCall(opcode, owner, name, desc)) {
                        Transformer.this.notifyError("Invalid use of await at %s.%s", cr.getClassName(), original.name);
                        this.visitMethodInsn(185, Transformer.COMPLETION_STAGE_NAME, "toCompletableFuture", "()Ljava/util/concurrent/CompletableFuture;", true);
                        this.visitMethodInsn(182, Transformer.COMPLETABLE_FUTURE_NAME, Transformer.JOIN_METHOD_NAME, Transformer.JOIN_METHOD_DESC, false);
                    } else if (Transformer.this.isAwaitInitCall(opcode, owner, name, desc)) {
                        super.visitInsn(0);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                }
            }
            original.accept(new MyMethodVisitor(replacement));
            classNode.methods.remove(original);
            replacement.accept(classNode);
        }
        if (countInstrumented == 0) {
            return null;
        }
        ClassWriter cw = new ClassWriter(1){

            @Override
            protected String getCommonSuperClass(String type1, String type2) {
                return type1.equals(type2) ? type1 : "java/lang/Object";
            }
        };
        classNode.accept(cw);
        byte[] bytes = cw.toByteArray();
        return bytes;
    }

    private boolean returnsCompletionStageSubClass(ClassLoader classLoader, MethodNode original) {
        Type retType = Type.getReturnType(original.desc);
        if (retType.getSort() != 10) {
            return false;
        }
        String retTypeName = retType.getInternalName();
        return this.isCompletionStage(classLoader, retTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCompletionStage(ClassLoader classLoader, String internalName) {
        Boolean aBoolean;
        if (COMPLETION_STAGE_NAME.equals(internalName)) {
            return true;
        }
        if (COMPLETABLE_FUTURE_NAME.equals(internalName)) {
            return true;
        }
        URL resource = classLoader.getResource(internalName + ".class");
        WeakHashMap<Object, Object> weakHashMap = futureMap;
        synchronized (weakHashMap) {
            aBoolean = futureMap.get(resource);
        }
        if (aBoolean != null) {
            return aBoolean;
        }
        aBoolean = this.isCompletionStage(classLoader, classLoader.getResourceAsStream(internalName + ".class"));
        weakHashMap = classLoaderMap;
        synchronized (weakHashMap) {
            Set<URL> urls = classLoaderMap.get(classLoader);
            if (urls == null) {
                urls = new HashSet<URL>();
                classLoaderMap.put(classLoader, urls);
            }
            urls.add(resource);
        }
        weakHashMap = futureMap;
        synchronized (weakHashMap) {
            futureMap.put(resource, aBoolean);
        }
        return aBoolean;
    }

    private boolean isCompletionStage(ClassLoader classLoader, InputStream resource) {
        if (resource == null) {
            return false;
        }
        try {
            return this.isCompletionStage(classLoader, new ClassReader(resource).getSuperName());
        }
        catch (IOException e) {
            return false;
        }
    }

    private void transformAsyncMethod(final ClassNode classNode, final MethodNode original, Map<String, Integer> nameUseCount) throws AnalyzerException {
        final ArrayList<Object> switchEntries = new ArrayList<Object>();
        final ArrayList<Argument> arguments = new ArrayList<Argument>();
        ArrayList<Label> switchLabels = new ArrayList<Label>();
        FrameAnalyzer analyzer = new FrameAnalyzer();
        Frame<V>[] frames = analyzer.analyze(classNode.name, original);
        SwitchEntry entryPoint = new SwitchEntry(0, (FrameAnalyzer.ExtendedFrame)frames[0], 0);
        switchLabels.add(entryPoint.resumeLabel);
        int ii = 0;
        int count = 0;
        ListIterator<AbstractInsnNode> it = original.instructions.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof MethodInsnNode && this.isAwaitCall((MethodInsnNode)o)) {
                SwitchEntry se = new SwitchEntry(++count, (FrameAnalyzer.ExtendedFrame)frames[ii], ii);
                switchLabels.add(se.resumeLabel);
                switchEntries.add(se);
            }
            ++ii;
        }
        int newMaxLocals = 0;
        HashSet<AbstractInsnNode> uninitializedObjects = new HashSet<AbstractInsnNode>();
        for (SwitchEntry switchEntry : switchEntries) {
            BasicValue value;
            int j;
            arguments.forEach(new Consumer<Argument>(){

                @Override
                public void accept(Argument p) {
                    p.tmpLocalMapping = -1;
                }
            });
            switchEntry.stackToNewLocal = new int[switchEntry.frame.getStackSize()];
            Arrays.fill(switchEntry.stackToNewLocal, -1);
            int iNewLocal = original.maxLocals;
            for (j = 0; j < switchEntry.frame.getStackSize(); ++j) {
                value = (BasicValue)switchEntry.frame.getStack(j);
                if (value != null && !this.isUninitialized(value)) {
                    switchEntry.stackToNewLocal[j] = iNewLocal;
                    iNewLocal += this.valueSize((Value)switchEntry.frame.getStack(j));
                } else {
                    switchEntry.stackToNewLocal[j] = -1;
                }
                if (!this.isUninitialized(value)) continue;
                uninitializedObjects.add(((FrameAnalyzer.ExtendedValue)value).insnNode);
            }
            newMaxLocals = Math.max(iNewLocal, newMaxLocals);
            switchEntry.localToiArgument = new int[newMaxLocals];
            Arrays.fill(switchEntry.localToiArgument, -1);
            for (int iLocal = 0; iLocal < switchEntry.frame.getLocals(); iLocal += this.valueSize((Value)switchEntry.frame.getLocal(iLocal))) {
                value = (BasicValue)switchEntry.frame.getLocal(iLocal);
                if (value != null && !this.isUninitialized(value) && value.getType() != null) {
                    this.mapLocalToLambdaArgument(original, switchEntry, arguments, iLocal, value);
                }
                if (!this.isUninitialized(value)) continue;
                uninitializedObjects.add(((FrameAnalyzer.ExtendedValue)value).insnNode);
            }
            for (j = 0; j < switchEntry.frame.getStackSize(); ++j) {
                int iLocal = switchEntry.stackToNewLocal[j];
                if (iLocal < 0) continue;
                this.mapLocalToLambdaArgument(original, switchEntry, arguments, iLocal, (BasicValue)switchEntry.frame.getStack(j));
            }
            switchEntry.argumentToLocal = new int[arguments.size()];
            for (j = 0; j < arguments.size(); ++j) {
                switchEntry.argumentToLocal[j] = ((Argument)arguments.get((int)j)).tmpLocalMapping;
                if (switchEntry.argumentToLocal[j] < 0) continue;
                switchEntry.localToiArgument[switchEntry.argumentToLocal[j]] = ((Argument)arguments.get((int)j)).iArgumentLocal;
            }
        }
        if (uninitializedObjects.size() > 0) {
            this.replaceObjectInitialization(original, frames, uninitializedObjects);
        }
        original.maxLocals = Math.max(original.maxLocals, newMaxLocals);
        arguments.forEach(new Consumer<Argument>(){

            @Override
            public void accept(Argument p) {
                p.tmpLocalMapping = -2;
            }
        });
        Argument stateArgument = this.mapLocalToLambdaArgument(original, null, arguments, 0, BasicValue.INT_VALUE);
        Argument argument = this.mapLocalToLambdaArgument(original, null, arguments, 0, BasicValue.REFERENCE_VALUE);
        stateArgument.name = "async$state";
        argument.name = "async$input";
        Object[] defaultFrame = arguments.stream().map(new Function<Argument, Object>(){

            @Override
            public Object apply(Argument a) {
                return Transformer.this.toFrameType(a.value);
            }
        }).toArray();
        Type[] typeArguments = (Type[])arguments.stream().map(new Function<Argument, Type>(){

            @Override
            public Type apply(Argument a) {
                return a.value.getType();
            }
        }).toArray((IntFunction<A[]>)new IntFunction<Type[]>(){

            @Override
            public Type[] apply(int s) {
                return new Type[s];
            }
        });
        final String lambdaDesc = Type.getMethodDescriptor(Type.getType(Function.class), Arrays.copyOf(typeArguments, typeArguments.length - 1));
        MethodNode replacement = new MethodNode(original.access, original.name, original.desc, original.signature, original.exceptions.toArray(new String[original.exceptions.size()]));
        boolean staticSynchronized = (original.access & 0x20) != 0 && (original.access & 8) != 0;
        final boolean instanceSynchronized = (original.access & 0x20) != 0 && (original.access & 8) == 0;
        final MethodNode continued = new MethodNode(0x100A | (staticSynchronized ? 32 : 0), original.name, original.desc, original.signature, original.exceptions.toArray(new String[original.exceptions.size()]));
        String continuedName = "async$" + original.name;
        Integer countUses = nameUseCount.get(continuedName);
        nameUseCount.put(continuedName, countUses == null ? 1 : countUses + 1);
        continued.name = countUses == null ? continuedName : continuedName + "$" + countUses;
        continued.desc = Type.getMethodDescriptor(COMPLETABLE_FUTURE_TYPE, typeArguments);
        continued.signature = null;
        boolean isInterface = (classNode.access & 0x200) == 512;
        final Handle handle = new Handle(6, classNode.name, continued.name, continued.desc, isInterface);
        final boolean nonCompFutReturn = !original.desc.endsWith(COMPLETABLE_FUTURE_RET) && !original.desc.endsWith(COMPLETION_STAGE_RET);
        class MyMethodVisitor
        extends MethodVisitor {
            int awaitIndex;

            public MyMethodVisitor(MethodNode mv) {
                super(327680, mv);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (Transformer.this.isAwaitCall(opcode, owner, name, desc)) {
                    Transformer.this.transformAwait(classNode, original, this, (SwitchEntry)switchEntries.get(this.awaitIndex++), lambdaDesc, arguments, this.mv == continued, nonCompFutReturn, handle);
                } else if (Transformer.this.isAwaitInitCall(opcode, owner, name, desc)) {
                    super.visitInsn(0);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }

            @Override
            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                super.visitFrame(type == -1 ? 0 : type, nLocal, local, nStack, stack);
            }

            @Override
            public void visitInsn(int opcode) {
                if (opcode == 176 && this.mv == continued && instanceSynchronized) {
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitInsn(195);
                }
                super.visitInsn(opcode);
            }
        }
        original.accept(new MyMethodVisitor(replacement));
        Label thisMonitorStart = null;
        Label thisMonitorEnd = null;
        if (instanceSynchronized) {
            thisMonitorStart = new Label();
            thisMonitorEnd = new Label();
            continued.visitVarInsn(25, 0);
            continued.visitInsn(194);
            continued.visitLabel(thisMonitorStart);
            continued.visitTryCatchBlock(thisMonitorStart, thisMonitorEnd, thisMonitorEnd, null);
        }
        continued.visitVarInsn(21, stateArgument.iArgumentLocal);
        Label defaultLabel = new Label();
        continued.visitTableSwitchInsn(0, switchLabels.size() - 1, defaultLabel, switchLabels.toArray(new Label[switchLabels.size()]));
        continued.visitLabel(entryPoint.resumeLabel);
        continued.visitFrame(0, defaultFrame.length, defaultFrame, 0, new Object[0]);
        this.restoreStackAndLocals(classNode, original, continued, entryPoint, arguments);
        original.accept(new MyMethodVisitor(continued));
        Label lastRestorePoint = null;
        for (SwitchEntry switchEntry : switchEntries) {
            continued.visitLabel(switchEntry.resumeLabel);
            continued.visitFrame(0, defaultFrame.length, defaultFrame, 0, new Object[0]);
            this.restoreStackAndLocals(classNode, original, continued, switchEntry, arguments);
            if (!Modifier.isStatic(original.access)) {
                if (lastRestorePoint != null) {
                    continued.visitLocalVariable(_THIS, "L" + classNode.name + ";", null, lastRestorePoint, switchEntry.resumeLabel, 0);
                }
                lastRestorePoint = new Label();
                continued.visitLabel(lastRestorePoint);
            }
            continued.visitJumpInsn(167, switchEntry.futureIsDoneLabel);
        }
        continued.visitLabel(defaultLabel);
        continued.visitFrame(0, defaultFrame.length, defaultFrame, 0, new Object[0]);
        continued.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        continued.visitInsn(89);
        continued.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", ASYNC_INIT_METHOD_DESC, false);
        continued.visitInsn(191);
        if (!Modifier.isStatic(original.access) && lastRestorePoint != null) {
            Label endLabel = new Label();
            continued.visitLabel(endLabel);
            continued.visitLocalVariable(_THIS, "L" + classNode.name + ";", null, lastRestorePoint, endLabel, 0);
        }
        if (instanceSynchronized) {
            continued.visitLabel(thisMonitorEnd);
            continued.visitFrame(0, 1, new Object[]{classNode.name}, 1, new Object[]{Type.getType(Throwable.class).getInternalName()});
            continued.visitVarInsn(25, 0);
            continued.visitInsn(195);
            continued.visitInsn(191);
        }
        classNode.methods.remove(original);
        replacement.maxStack = Math.max(16, replacement.maxStack + 16);
        replacement.accept(classNode);
        continued.maxLocals = Math.max(16, continued.maxLocals + 16);
        continued.maxStack = Math.max(16, continued.maxStack + 16);
        continued.accept(classNode);
    }

    private Argument mapLocalToLambdaArgument(MethodNode originalMethod, SwitchEntry se, final List<Argument> arguments, int local, final BasicValue value) {
        if (ACONST_NULL_TYPE.equals(value.getType())) {
            return null;
        }
        Argument argument = null;
        final String name = local < originalMethod.maxLocals ? this.guessName(originalMethod, se, local) : "_stack$" + (local - originalMethod.maxLocals);
        argument = arguments.stream().filter(new Predicate<Argument>(){

            @Override
            public boolean test(Argument x) {
                return x.tmpLocalMapping == -1 && x.value.equals(value) && x.name.equals(name);
            }
        }).findFirst().orElse(null);
        if (argument != null) {
            argument.tmpLocalMapping = local;
            return argument;
        }
        argument = arguments.stream().filter(new Predicate<Argument>(){

            @Override
            public boolean test(Argument x) {
                return x.tmpLocalMapping == -1 && x.value.equals(value);
            }
        }).findFirst().orElseGet(new Supplier<Argument>(){

            @Override
            public Argument get() {
                Argument np = new Argument();
                np.iArgumentLocal = arguments.size() == 0 ? 0 : ((Argument)arguments.get((int)(arguments.size() - 1))).iArgumentLocal + ((Argument)arguments.get((int)(arguments.size() - 1))).value.getSize();
                np.value = value;
                np.name = name == null ? name : "_arg$" + np.iArgumentLocal;
                arguments.add(np);
                return np;
            }
        });
        argument.tmpLocalMapping = local;
        return argument;
    }

    private String guessName(MethodNode method, SwitchEntry se, int local) {
        if (se != null) {
            for (LocalVariableNode node : method.localVariables) {
                if (node.index != local || method.instructions.indexOf(node.start) > se.index || method.instructions.indexOf(node.end) < se.index) continue;
                return node.name;
            }
        }
        return "_local$" + local;
    }

    private boolean isUninitialized(Value value) {
        return value instanceof FrameAnalyzer.ExtendedValue && ((FrameAnalyzer.ExtendedValue)value).isUninitialized();
    }

    private int valueSize(Value local) {
        return local == null ? 1 : local.getSize();
    }

    void replaceObjectInitialization(MethodNode methodNode, Frame<BasicValue>[] frames, Set<AbstractInsnNode> objectCreationNodes) {
        AbstractInsnNode insnNode;
        int originalLocals = methodNode.maxLocals;
        Set<AbstractInsnNode> uninitializedObjects = objectCreationNodes != null ? objectCreationNodes : Stream.of(methodNode.instructions.toArray()).filter(new Predicate<AbstractInsnNode>(){

            @Override
            public boolean test(AbstractInsnNode i) {
                return i.getOpcode() == 187;
            }
        }).collect(Collectors.toSet());
        int index = 0;
        for (insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (insnNode instanceof FrameNode) {
                FrameNode frameNode = (FrameNode)insnNode;
                frameNode.stack = this.replaceUninitializedFrameValues(uninitializedObjects, frameNode.stack);
                frameNode.local = this.replaceUninitializedFrameValues(uninitializedObjects, frameNode.local);
            } else if (insnNode.getOpcode() == 183) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                if (methodInsnNode.name.equals("<init>")) {
                    insnNode = this.replaceConstructorCall(methodNode, frames[index], uninitializedObjects, originalLocals, methodInsnNode);
                }
            }
            ++index;
        }
        for (insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (insnNode.getOpcode() != 187 || !uninitializedObjects.contains(insnNode)) continue;
            InsnNode newInsn = new InsnNode(1);
            methodNode.instructions.insertBefore(insnNode, newInsn);
            methodNode.instructions.remove(insnNode);
            insnNode = newInsn;
        }
    }

    private AbstractInsnNode replaceConstructorCall(MethodNode methodNode, Frame<BasicValue> frame, Set<AbstractInsnNode> uninitializedObjects, int originalLocals, MethodInsnNode methodInsnNode) {
        int j;
        BasicValue local;
        int firstOccurrence;
        Type[] oldArguments = Type.getArgumentTypes(methodInsnNode.desc);
        int targetStackIndex = frame.getStackSize() - (1 + oldArguments.length);
        FrameAnalyzer.ExtendedValue target = (FrameAnalyzer.ExtendedValue)frame.getStack(targetStackIndex);
        if (uninitializedObjects != null && !uninitializedObjects.contains(target.insnNode)) {
            return methodInsnNode;
        }
        InsnList instructions = methodNode.instructions;
        AbstractInsnNode currentInsn = methodInsnNode;
        int[] stackToLocal = new int[frame.getStackSize()];
        Arrays.fill(stackToLocal, -1);
        for (firstOccurrence = 0; firstOccurrence < targetStackIndex && !target.equals(frame.getStack(firstOccurrence)); ++firstOccurrence) {
        }
        int repetitions = 1;
        for (int i = firstOccurrence + 1; i < frame.getStackSize() && target.equals(frame.getStack(i)); ++i) {
            ++repetitions;
        }
        int newMaxLocals = 0;
        int newObject = -1;
        int iLocal = originalLocals;
        int j2 = frame.getStackSize();
        while (--j2 >= firstOccurrence) {
            BasicValue value = frame.getStack(j2);
            if (value.getType() == null) {
                MethodInsnNode methodInsnNode2 = currentInsn;
                currentInsn = new InsnNode(87);
                instructions.insert((AbstractInsnNode)methodInsnNode2, currentInsn);
                AbstractInsnNode abstractInsnNode = currentInsn;
                currentInsn = new InsnNode(1);
                instructions.insert(abstractInsnNode, currentInsn);
                value = BasicValue.REFERENCE_VALUE;
            }
            if (!target.equals(value)) {
                stackToLocal[j2] = iLocal;
                AbstractInsnNode abstractInsnNode = currentInsn;
                currentInsn = new VarInsnNode(value.getType().getOpcode(54), iLocal);
                instructions.insert(abstractInsnNode, currentInsn);
                iLocal += this.valueSize(value);
            } else {
                if (j2 >= firstOccurrence + repetitions) {
                    stackToLocal[j2] = newObject != -1 ? newObject : (newObject = iLocal++);
                }
                AbstractInsnNode abstractInsnNode = currentInsn;
                currentInsn = new InsnNode(87);
                instructions.insert(abstractInsnNode, currentInsn);
            }
            newMaxLocals = iLocal;
        }
        methodNode.maxLocals = Math.max(newMaxLocals, methodNode.maxLocals);
        MethodInsnNode methodInsnNode3 = currentInsn;
        currentInsn = new TypeInsnNode(187, target.getType().getInternalName());
        instructions.insert((AbstractInsnNode)methodInsnNode3, currentInsn);
        for (j = 0; j < frame.getLocals(); j += local.getSize()) {
            local = frame.getLocal(j);
            if (!target.equals(local)) continue;
            AbstractInsnNode abstractInsnNode = currentInsn;
            currentInsn = new InsnNode(89);
            instructions.insert(abstractInsnNode, currentInsn);
            AbstractInsnNode abstractInsnNode2 = currentInsn;
            currentInsn = new VarInsnNode(58, j);
            instructions.insert(abstractInsnNode2, currentInsn);
        }
        if (firstOccurrence < targetStackIndex) {
            for (int i = 1; i < repetitions; ++i) {
                AbstractInsnNode abstractInsnNode = currentInsn;
                currentInsn = new InsnNode(89);
                instructions.insert(abstractInsnNode, currentInsn);
            }
            if (newObject != -1) {
                AbstractInsnNode abstractInsnNode = currentInsn;
                currentInsn = new InsnNode(89);
                instructions.insert(abstractInsnNode, currentInsn);
                AbstractInsnNode abstractInsnNode3 = currentInsn;
                currentInsn = new VarInsnNode(58, newObject);
                instructions.insert(abstractInsnNode3, currentInsn);
            }
        }
        for (j = firstOccurrence + repetitions; j < frame.getStackSize(); ++j) {
            BasicValue value = frame.getStack(j);
            if (value.getType() != null) {
                AbstractInsnNode abstractInsnNode = currentInsn;
                currentInsn = new VarInsnNode(value.getType().getOpcode(21), stackToLocal[j]);
                instructions.insert(abstractInsnNode, currentInsn);
                continue;
            }
            AbstractInsnNode abstractInsnNode = currentInsn;
            currentInsn = new InsnNode(1);
            instructions.insert(abstractInsnNode, currentInsn);
        }
        instructions.remove(methodInsnNode);
        AbstractInsnNode abstractInsnNode = currentInsn;
        currentInsn = methodInsnNode;
        instructions.insert(abstractInsnNode, currentInsn);
        return currentInsn;
    }

    private List<Object> replaceUninitializedFrameValues(Set<AbstractInsnNode> uninitializedObjects, List<Object> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> newList = new ArrayList<Object>(list);
        int l = newList.size();
        for (int i = 0; i < l; ++i) {
            Object v = newList.get(i);
            if (!(v instanceof LabelNode)) continue;
            AbstractInsnNode node = (AbstractInsnNode)v;
            while (!(node instanceof TypeInsnNode) || node.getOpcode() != 187) {
                node = node.getNext();
            }
            if (!uninitializedObjects.contains(node)) continue;
            newList.set(i, Type.getType(((TypeInsnNode)node).desc).getInternalName());
        }
        return newList;
    }

    private void transformAwait(ClassNode classNode, MethodNode original, MethodVisitor mv, SwitchEntry switchEntry, String lambdaDesc, List<Argument> lambdaArguments, boolean isContinued, boolean nonCompFutReturn, Handle handle) {
        boolean needsConversion;
        mv.visitInsn(89);
        Label futureIsDoneLabel = isContinued ? switchEntry.futureIsDoneLabel : new Label();
        boolean bl = needsConversion = switchEntry == null || !this.checkType(switchEntry.frame, COMPLETABLE_FUTURE_TYPE);
        if (needsConversion) {
            mv.visitMethodInsn(185, COMPLETION_STAGE_NAME, "toCompletableFuture", "()Ljava/util/concurrent/CompletableFuture;", true);
        }
        mv.visitMethodInsn(182, COMPLETABLE_FUTURE_NAME, "isDone", "()Z", false);
        mv.visitJumpInsn(154, futureIsDoneLabel);
        this.saveStack(mv, switchEntry);
        mv.visitVarInsn(25, switchEntry.stackToNewLocal[switchEntry.frame.getStackSize() - 1]);
        mv.visitMethodInsn(184, Type.getType(Function.class).getInternalName(), "identity", "()Ljava/util/function/Function;", true);
        if (needsConversion) {
            mv.visitMethodInsn(185, COMPLETION_STAGE_NAME, "exceptionally", "(Ljava/util/function/Function;)Ljava/util/concurrent/CompletionStage;", true);
        } else {
            mv.visitMethodInsn(182, COMPLETABLE_FUTURE_NAME, "exceptionally", "(Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", false);
        }
        this.pushArguments(mv, switchEntry, lambdaArguments);
        mv.visitIntInsn(17, switchEntry.key);
        mv.visitInvokeDynamicInsn("apply", lambdaDesc, METAFACTORY_HANDLE, Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"), handle, Type.getType("(Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;"));
        if (needsConversion) {
            mv.visitMethodInsn(185, COMPLETION_STAGE_NAME, "thenCompose", "(Ljava/util/function/Function;)Ljava/util/concurrent/CompletionStage;", true);
        } else {
            mv.visitMethodInsn(182, COMPLETABLE_FUTURE_NAME, "thenCompose", "(Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", false);
        }
        if (needsConversion) {
            mv.visitMethodInsn(185, COMPLETION_STAGE_NAME, "toCompletableFuture", "()Ljava/util/concurrent/CompletableFuture;", true);
        }
        if (!isContinued && nonCompFutReturn) {
            String retType = Type.getReturnType(original.desc).getInternalName();
            String castFunction = "lambda$checkCast$" + retType.replace('/', '_');
            this.generateCheckCast(classNode, castFunction, retType);
            boolean isInterface = (classNode.access & 0x200) == 512;
            mv.visitMethodInsn(184, classNode.name, castFunction, "(Ljava/util/concurrent/CompletionStage;)L" + retType + ";", isInterface);
            mv.visitTypeInsn(192, retType);
        }
        if (switchEntry.frame.monitors.length > 0) {
            int i = switchEntry.frame.monitors.length;
            while (--i >= 0) {
                BasicValue monitorValue = switchEntry.frame.monitors[i];
                int monitorLocal = -1;
                for (int iLocal = 0; iLocal < switchEntry.frame.getLocals(); iLocal += this.valueSize((Value)switchEntry.frame.getLocal(iLocal))) {
                    if (switchEntry.frame.getLocal(iLocal) != monitorValue) continue;
                    monitorLocal = iLocal;
                }
                if (monitorLocal != -1) {
                    mv.visitVarInsn(25, monitorLocal);
                    mv.visitInsn(195);
                    continue;
                }
                this.notifyError("Error restoring monitors in synchronized method. monitorLocal=%d, at %s.%s", monitorLocal, classNode.name, original.name);
            }
        }
        mv.visitInsn(176);
        mv.visitLabel(futureIsDoneLabel);
        this.fullFrame(mv, switchEntry.frame);
        if (needsConversion) {
            mv.visitMethodInsn(185, COMPLETION_STAGE_NAME, "toCompletableFuture", "()Ljava/util/concurrent/CompletableFuture;", true);
        }
        mv.visitMethodInsn(182, COMPLETABLE_FUTURE_NAME, JOIN_METHOD_NAME, JOIN_METHOD_DESC, false);
    }

    private boolean checkType(FrameAnalyzer.ExtendedFrame frame, Type type) {
        BasicValue value;
        return frame != null && (value = (BasicValue)frame.getStack(frame.getStackSize() - 1)) != null && value.getType() != null && type.equals(value.getType());
    }

    private void generateCheckCast(ClassNode classNode, String castFunction, String retType) {
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(castFunction)) continue;
            return;
        }
        MethodVisitor mv = classNode.visitMethod(4106, castFunction, "(Ljava/util/concurrent/CompletionStage;)L" + retType + ";", null, null);
        mv.visitCode();
        Label beginLabel = new Label();
        Label elseLabel = new Label();
        Label varLabel = new Label();
        mv.visitLabel(beginLabel);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(193, retType);
        mv.visitJumpInsn(153, elseLabel);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(192, retType);
        mv.visitInsn(176);
        mv.visitLabel(elseLabel);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitTypeInsn(187, retType);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, retType, "<init>", ASYNC_INIT_METHOD_DESC, false);
        mv.visitVarInsn(58, 1);
        mv.visitLabel(varLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        String whenCompleteName = "lambda$cast$whenComplete";
        mv.visitInvokeDynamicInsn("accept", "(Ljava/util/concurrent/CompletableFuture;)Ljava/util/function/BiConsumer;", METAFACTORY_HANDLE, Type.getType("(Ljava/lang/Object;Ljava/lang/Object;)V"), new Handle(6, classNode.name, "lambda$cast$whenComplete", "(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Object;Ljava/lang/Throwable;)V"), Type.getType("(Ljava/lang/Object;Ljava/lang/Throwable;)V"));
        this.generateWhenComplete(classNode, "lambda$cast$whenComplete");
        mv.visitMethodInsn(185, COMPLETION_STAGE_NAME, "whenComplete", "(Ljava/util/function/BiConsumer;)Ljava/util/concurrent/CompletionStage;", true);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        Label endLabel = new Label();
        mv.visitLabel(endLabel);
        mv.visitLocalVariable("stage", "Ljava/util/concurrent/CompletionStage;", null, beginLabel, endLabel, 0);
        mv.visitLocalVariable("t", "L" + retType + ";", null, varLabel, endLabel, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void generateWhenComplete(ClassNode classNode, String lambdaName) {
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(lambdaName)) continue;
            return;
        }
        MethodVisitor mv = classNode.visitMethod(4106, lambdaName, "(Ljava/util/concurrent/CompletableFuture;Ljava/lang/Object;Ljava/lang/Throwable;)V", null, null);
        mv.visitCode();
        Label beginLabel = new Label();
        Label elseLabel = new Label();
        Label skip = new Label();
        Label endLabel = new Label();
        mv.visitLabel(beginLabel);
        mv.visitVarInsn(25, 2);
        mv.visitJumpInsn(198, elseLabel);
        Label exceptionLabel = new Label();
        mv.visitLabel(exceptionLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, COMPLETABLE_FUTURE_NAME, "completeExceptionally", "(Ljava/lang/Throwable;)Z", false);
        mv.visitInsn(87);
        mv.visitJumpInsn(167, skip);
        mv.visitLabel(elseLabel);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, COMPLETABLE_FUTURE_NAME, "complete", "(Ljava/lang/Object;)Z", false);
        mv.visitInsn(87);
        mv.visitLabel(skip);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        mv.visitLabel(endLabel);
        mv.visitLocalVariable("future", COMPLETABLE_FUTURE_DESCRIPTOR, null, beginLabel, endLabel, 0);
        mv.visitLocalVariable("result", "Ljava/lang/Object;", null, beginLabel, endLabel, 1);
        mv.visitLocalVariable("exception", "Ljava/lang/Throwable;", null, beginLabel, endLabel, 2);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
    }

    private void fullFrame(MethodVisitor mv, Frame frame) {
        Type type;
        BasicValue value;
        int i;
        Object[] locals = new Object[frame.getLocals()];
        Object[] stack = new Object[frame.getStackSize()];
        int nStack = 0;
        int nLocals = 0;
        int maxLocal = 0;
        for (i = 0; i < locals.length; ++i) {
            value = (BasicValue)frame.getLocal(i);
            type = value.getType();
            if (type == null) {
                locals[nLocals++] = Opcodes.TOP;
                continue;
            }
            locals[nLocals++] = this.toFrameType(value);
            if (value.getSize() == 2) {
                ++i;
            }
            maxLocal = nLocals;
        }
        for (i = 0; i < frame.getStackSize(); ++i) {
            value = (BasicValue)frame.getStack(i);
            type = value.getType();
            if (type == null) continue;
            stack[nStack++] = this.toFrameType(value);
        }
        stack = nStack == stack.length ? stack : Arrays.copyOf(stack, nStack);
        locals = nLocals == locals.length ? locals : Arrays.copyOf(locals, maxLocal);
        mv.visitFrame(0, maxLocal, locals, nStack, stack);
    }

    private Object toFrameType(BasicValue value) {
        Type type = value.getType();
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Opcodes.INTEGER;
            }
            case 7: {
                return Opcodes.LONG;
            }
            case 6: {
                return Opcodes.FLOAT;
            }
            case 8: {
                return Opcodes.DOUBLE;
            }
        }
        String internalName = type.getInternalName();
        if (ACONST_NULL_TYPE.equals(type)) {
            return Opcodes.NULL;
        }
        return internalName;
    }

    private boolean isAwaitCall(MethodInsnNode methodIns) {
        return this.isAwaitCall(methodIns.getOpcode(), methodIns.owner, methodIns.name, methodIns.desc);
    }

    private boolean isAwaitCall(int opcode, String owner, String name, String desc) {
        return opcode == 184 && ASYNC_METHOD_NAME.equals(name) && ASYNC_NAME.equals(owner);
    }

    private boolean isAwaitInitCall(MethodInsnNode methodIns) {
        return this.isAwaitInitCall(methodIns.getOpcode(), methodIns.owner, methodIns.name, methodIns.desc);
    }

    private boolean isAwaitInitCall(int opcode, String owner, String name, String desc) {
        return opcode == 184 && ASYNC_INIT_METHOD_NAME.equals(name) && ASYNC_NAME.equals(owner) && ASYNC_INIT_METHOD_DESC.equals(desc);
    }

    private void saveStack(MethodVisitor mv, SwitchEntry se) {
        int i = se.stackToNewLocal.length;
        while (--i >= 0) {
            int iLocal = se.stackToNewLocal[i];
            if (iLocal >= 0) {
                mv.visitVarInsn(((BasicValue)se.frame.getStack(i)).getType().getOpcode(54), iLocal);
                continue;
            }
            mv.visitInsn(((BasicValue)se.frame.getStack(i)).getType().getSize() == 2 ? 88 : 87);
        }
    }

    private void pushArguments(MethodVisitor mv, SwitchEntry switchEntry, List<Argument> lambdaArguments) {
        int l = lambdaArguments.size() - 2;
        for (int i = 0; i < l; ++i) {
            int iLocal = i < switchEntry.argumentToLocal.length ? switchEntry.argumentToLocal[i] : -1;
            BasicValue value = lambdaArguments.get((int)i).value;
            if (iLocal >= 0) {
                mv.visitVarInsn(value.getType().getOpcode(21), iLocal);
                continue;
            }
            this.pushDefault(mv, value);
        }
    }

    private void pushDefault(MethodVisitor mv, BasicValue value) {
        if (value.getType() == null) {
            mv.visitInsn(1);
            return;
        }
        switch (value.getType().getSort()) {
            case 0: {
                mv.visitInsn(1);
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitInsn(3);
                return;
            }
            case 6: {
                mv.visitInsn(11);
                return;
            }
            case 7: {
                mv.visitInsn(9);
                return;
            }
            case 8: {
                mv.visitInsn(14);
                return;
            }
            case 9: 
            case 10: {
                mv.visitInsn(1);
                return;
            }
        }
        throw new Error("Internal error");
    }

    private void restoreStackAndLocals(ClassNode classNode, MethodNode original, MethodVisitor mv, SwitchEntry se, List<Argument> lambdaArguments) {
        int iLocal;
        BasicValue value;
        int i;
        if (se.argumentToLocal == null) {
            return;
        }
        FrameAnalyzer.ExtendedFrame frame = se.frame;
        for (i = 0; i < frame.getStackSize(); ++i) {
            value = (BasicValue)frame.getStack(i);
            int iLocal2 = se.stackToNewLocal[i];
            if (iLocal2 >= 0 && se.localToiArgument[iLocal2] >= 0) {
                mv.visitVarInsn(value.getType().getOpcode(21), se.localToiArgument[iLocal2]);
                continue;
            }
            this.pushDefault(mv, value);
        }
        for (iLocal = 0; iLocal < frame.getLocals(); iLocal += this.valueSize((Value)frame.getLocal(iLocal))) {
            value = (BasicValue)frame.getLocal(iLocal);
            if (se.localToiArgument[iLocal] < 0 || se.localToiArgument[iLocal] == iLocal) continue;
            mv.visitVarInsn(value.getType().getOpcode(21), se.localToiArgument[iLocal]);
        }
        iLocal = frame.getLocals();
        while (--iLocal >= 0) {
            if (se.localToiArgument[iLocal] < 0 || se.localToiArgument[iLocal] == iLocal) continue;
            mv.visitVarInsn(((BasicValue)frame.getLocal(iLocal)).getType().getOpcode(54), iLocal);
        }
        for (iLocal = 0; iLocal < frame.getLocals(); iLocal += this.valueSize((Value)frame.getLocal(iLocal))) {
            value = (BasicValue)frame.getLocal(iLocal);
            if (se.localToiArgument[iLocal] >= 0 || value == null || value.getType() == null) continue;
            this.pushDefault(mv, value);
            mv.visitVarInsn(value.getType().getOpcode(54), iLocal);
        }
        for (i = 0; i < se.frame.monitors.length; ++i) {
            BasicValue monitorValue = frame.monitors[i];
            int monitorLocal = -1;
            for (int iLocal3 = 0; iLocal3 < frame.getLocals(); iLocal3 += this.valueSize((Value)frame.getLocal(iLocal3))) {
                if (frame.getLocal(iLocal3) != monitorValue) continue;
                monitorLocal = iLocal3;
            }
            if (monitorLocal != -1) {
                mv.visitVarInsn(25, monitorLocal);
                mv.visitInsn(194);
                continue;
            }
            this.notifyError("Error restoring monitors in synchronized method. monitorLocal=%d, at %s.%s", monitorLocal, classNode.name, original.name);
        }
    }

    boolean needsInstrumentation(ClassReader cr) {
        try {
            int address;
            int i;
            boolean hasAwaitCall = false;
            boolean hasAwait = false;
            int c = cr.getItemCount();
            for (i = 1; i < c; ++i) {
                address = cr.getItem(i);
                if (address <= 0 || cr.readByte(address - 1) != 7 || !this.equalsUtf8(cr, address, ASYNC_NAME)) continue;
                hasAwait = true;
                break;
            }
            if (!hasAwait) {
                return false;
            }
            c = cr.getItemCount();
            for (i = 1; i < c; ++i) {
                int classIndex;
                int tag;
                address = cr.getItem(i);
                if (address <= 0 || (tag = cr.readByte(address - 1)) != 11 && tag != 10 || (classIndex = cr.readUnsignedShort(address)) == 0) continue;
                int classAddress = cr.getItem(classIndex);
                int ntIndex = cr.readUnsignedShort(address + 2);
                if (ntIndex == 0) continue;
                int ntAddress = cr.getItem(ntIndex);
                if (!this.equalsUtf8(cr, classAddress, ASYNC_NAME)) continue;
                if (this.equalsUtf8(cr, ntAddress, ASYNC_METHOD_NAME)) {
                    return true;
                }
                if (!this.equalsUtf8(cr, ntAddress, ASYNC_INIT_METHOD_NAME) || !this.equalsUtf8(cr, ntAddress + 2, ASYNC_INIT_METHOD_DESC)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean equalsUtf8(ClassReader cr, int pointerToUtf8Index, String str) {
        int utf8_index = cr.readUnsignedShort(pointerToUtf8Index);
        if (utf8_index == 0) {
            return false;
        }
        int utf8_address = cr.getItem(utf8_index);
        int utf8_length = cr.readUnsignedShort(utf8_address);
        if (utf8_length == str.length()) {
            int idx = utf8_address + 2;
            int ic = 0;
            while (ic < utf8_length) {
                if (str.charAt(ic) != (char)cr.readByte(idx)) {
                    return false;
                }
                ++ic;
                ++idx;
            }
            return true;
        }
        return false;
    }

    boolean needsInstrumentation(Class<?> c) {
        try {
            InputStream resourceAsStream = c.getClassLoader().getResourceAsStream(Type.getInternalName(c) + ".class");
            if (resourceAsStream == null) {
                return false;
            }
            return this.needsInstrumentation(new ClassReader(resourceAsStream));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void setErrorListener(Consumer<String> errorListener) {
        this.errorListener = errorListener;
    }

    private void notifyError(String format, Object arg1, Object arg2) {
        if (this.errorListener != null) {
            this.errorListener.accept(String.format(format, arg1, arg2));
        }
    }

    private void notifyError(String format, Object arg1, Object arg2, Object arg3) {
        if (this.errorListener != null) {
            this.errorListener.accept(String.format(format, arg1, arg2, arg3));
        }
    }

    static class Argument {
        BasicValue value;
        String name;
        int iArgumentLocal;
        int tmpLocalMapping = -1;

        Argument() {
        }
    }

    static class SwitchEntry {
        final Label resumeLabel;
        final Label futureIsDoneLabel;
        final int key;
        final FrameAnalyzer.ExtendedFrame frame;
        final int index;
        public int[] stackToNewLocal;
        public int[] argumentToLocal;
        public int[] localToiArgument;

        public SwitchEntry(int key, FrameAnalyzer.ExtendedFrame frame, int index) {
            this.key = key;
            this.frame = frame;
            this.index = index;
            this.futureIsDoneLabel = new Label();
            this.resumeLabel = new Label();
        }
    }
}

